/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.opbehavior;

import ghidra.pcode.error.LowlevelError;
import ghidra.pcode.opbehavior.BinaryOpBehavior;
import java.math.BigInteger;

public class OpBehaviorIntRem
extends BinaryOpBehavior {
    public OpBehaviorIntRem() {
        super(35);
    }

    @Override
    public long evaluateBinary(int sizeout, int sizein, long in1, long in2) {
        if (in2 == 0L) {
            throw new LowlevelError("Remainder by 0");
        }
        return Long.remainderUnsigned(in1, in2);
    }

    @Override
    public BigInteger evaluateBinary(int sizeout, int sizein, BigInteger in1, BigInteger in2) {
        if (in2.signum() == 0) {
            throw new LowlevelError("Remainder by 0");
        }
        BigInteger res = in1.remainder(in2);
        return res;
    }
}

