/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.opbehavior;

import ghidra.pcode.opbehavior.BinaryOpBehavior;
import ghidra.pcode.utils.Utils;
import java.math.BigInteger;

public class OpBehaviorSubpiece
extends BinaryOpBehavior {
    public OpBehaviorSubpiece() {
        super(63);
    }

    @Override
    public long evaluateBinary(int sizeout, int sizein, long in1, long in2) {
        long res = in1 >>> (int)(in2 * 8L) & Utils.calc_mask((int)sizeout);
        return res;
    }

    @Override
    public BigInteger evaluateBinary(int sizeout, int sizein, BigInteger in1, BigInteger in2) {
        BigInteger res = in1;
        int signbit = sizein * 8 - 1;
        boolean negative = res.testBit(signbit);
        if (negative) {
            res = res.and(Utils.calc_bigmask((int)sizein));
            res = res.clearBit(signbit);
        }
        int shift = in2.intValue() * 8;
        res = res.shiftRight(shift);
        if (negative && (signbit -= shift) >= 0) {
            res = res.setBit(signbit);
        }
        return res;
    }
}

