/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.datastruct;

import ghidra.util.datastruct.FixedSizeHashMap;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class SoftCacheMap<K, V>
implements Map<K, V> {
    private int cacheSize;
    private LinkedHashMap<K, MySoftReference> map;
    private ReferenceQueue<? super V> refQueue;

    public SoftCacheMap(int cacheSize) {
        this.cacheSize = cacheSize;
        this.map = new FixedSizeHashMap<K, MySoftReference>(cacheSize, cacheSize);
        this.refQueue = new ReferenceQueue();
    }

    @Override
    public V put(K key, V value) {
        this.processQueue();
        MySoftReference ref = new MySoftReference(this, key, value);
        MySoftReference oldRef = this.map.put(key, ref);
        if (oldRef != null) {
            return (V)oldRef.get();
        }
        return null;
    }

    @Override
    public V get(Object key) {
        this.processQueue();
        MySoftReference ref = this.map.get(key);
        if (ref != null) {
            return (V)ref.get();
        }
        return null;
    }

    @Override
    public int size() {
        this.processQueue();
        return this.map.size();
    }

    @Override
    public void clear() {
        this.map.clear();
        this.refQueue = new ReferenceQueue();
    }

    @Override
    public boolean isEmpty() {
        this.processQueue();
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        this.processQueue();
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        this.processQueue();
        for (MySoftReference ref : this.map.values()) {
            if (!value.equals(ref.get())) continue;
            return true;
        }
        return false;
    }

    @Override
    public Collection<V> values() {
        ArrayList list = new ArrayList(this.map.size());
        for (MySoftReference ref : this.map.values()) {
            Object obj = ref.get();
            if (obj == null) continue;
            list.add(obj);
        }
        return list;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> t) {
        for (K key : t.keySet()) {
            V value = t.get(key);
            if (value == null) continue;
            this.put(key, value);
        }
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        this.processQueue();
        HashSet<Map.Entry<K, V>> result = new HashSet<Map.Entry<K, V>>();
        Set<Map.Entry<K, MySoftReference>> entrySet = this.map.entrySet();
        for (Map.Entry<K, MySoftReference> entry : entrySet) {
            MySoftReference value = entry.getValue();
            Object realValue = value.get();
            if (realValue == null) continue;
            AbstractMap.SimpleImmutableEntry newEntry = new AbstractMap.SimpleImmutableEntry(entry.getKey(), realValue);
            result.add(newEntry);
        }
        return result;
    }

    @Override
    public Set<K> keySet() {
        this.processQueue();
        return this.map.keySet();
    }

    @Override
    public V remove(Object key) {
        MySoftReference ref = (MySoftReference)this.map.remove(key);
        if (ref != null) {
            return (V)ref.get();
        }
        return null;
    }

    private void processQueue() {
        MySoftReference ref;
        while ((ref = (MySoftReference)this.refQueue.poll()) != null) {
            this.map.remove(ref.key);
        }
    }

    class MySoftReference
    extends SoftReference<V> {
        K key;

        MySoftReference(SoftCacheMap this$0, K key, V value) {
            super(value, this$0.refQueue);
            this.key = key;
        }
    }
}

