/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.dex;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.MemoryByteProvider;
import ghidra.file.formats.android.cdex.CDexHeader;
import ghidra.file.formats.android.dex.format.DexHeader;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import java.io.IOException;

public final class DexHeaderFactory {
    public static final DexHeader getDexHeader(Program program) throws IOException {
        return DexHeaderFactory.getDexHeader(program, program.getMinAddress());
    }

    public static final DexHeader getDexHeader(Program program, Address address) throws IOException {
        MemoryByteProvider provider = new MemoryByteProvider(program.getMemory(), address);
        return DexHeaderFactory.getDexHeader((ByteProvider)provider, !program.getLanguage().isBigEndian());
    }

    public static final DexHeader getDexHeader(ByteProvider provider, boolean isLittleEndian) throws IOException {
        BinaryReader reader = new BinaryReader(provider, isLittleEndian);
        return DexHeaderFactory.getDexHeader(reader);
    }

    public static final DexHeader getDexHeader(BinaryReader reader) throws IOException {
        return DexHeaderFactory.getDexHeader(reader, true);
    }

    public static final DexHeader getDexHeader(BinaryReader reader, boolean fullParse) throws IOException {
        long index = reader.getPointerIndex();
        String magic = new String(reader.readByteArray(index, 4));
        if ("dex\n".equals(magic)) {
            DexHeader header = new DexHeader(reader);
            if (fullParse) {
                header.parse(reader);
            }
            return header;
        }
        if ("cdex".equals(magic)) {
            CDexHeader header = new CDexHeader(reader);
            if (fullParse) {
                header.parse(reader);
            }
            return header;
        }
        throw new IOException("Not a recognized DEX/CDEX variant: " + magic);
    }
}

