/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.dex.format;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.LEB128Info;
import ghidra.app.util.bin.StructConverter;
import ghidra.file.formats.android.dex.format.DebugInfoStateMachineReader;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class DebugInfoItem
implements StructConverter {
    private int lineStart;
    private int lineStartLength;
    private int parametersSize;
    private int parametersSizeLength;
    private int[] parameterNames;
    private int[] parameterNamesLengths;
    private byte[] stateMachineOpcodes;

    public DebugInfoItem(BinaryReader reader) throws IOException {
        LEB128Info leb128 = (LEB128Info)reader.readNext(LEB128Info::unsigned);
        this.lineStart = leb128.asUInt32();
        this.lineStartLength = leb128.getLength();
        leb128 = (LEB128Info)reader.readNext(LEB128Info::unsigned);
        this.parametersSize = leb128.asUInt32();
        this.parametersSizeLength = leb128.getLength();
        this.parameterNames = new int[this.parametersSize];
        this.parameterNamesLengths = new int[this.parametersSize];
        for (int i = 0; i < this.parametersSize; ++i) {
            leb128 = (LEB128Info)reader.readNext(LEB128Info::unsigned);
            this.parameterNames[i] = leb128.asUInt32() - 1;
            this.parameterNamesLengths[i] = leb128.getLength();
        }
        int count = DebugInfoStateMachineReader.computeLength(reader.clone());
        this.stateMachineOpcodes = reader.readNextByteArray(count);
    }

    public int getLineStart() {
        return this.lineStart;
    }

    public int getParametersSize() {
        return this.parametersSize;
    }

    public int[] getParameterNames() {
        return this.parameterNames;
    }

    public byte[] getStateMachineOpcodes() {
        return this.stateMachineOpcodes;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        StringBuilder builder = new StringBuilder();
        builder.append("debug_info_item_");
        builder.append("" + this.lineStartLength);
        builder.append("" + this.parametersSizeLength);
        builder.append("" + this.parametersSize);
        builder.append("" + this.stateMachineOpcodes.length);
        StructureDataType structure = new StructureDataType(builder.toString(), 0);
        structure.add((DataType)ULEB128, this.lineStartLength, "line_start", null);
        structure.add((DataType)ULEB128, this.parametersSizeLength, "parameters_size", null);
        for (int i = 0; i < this.parametersSize; ++i) {
            structure.add((DataType)ULEB128, this.parameterNamesLengths[i], "parameter_" + i, null);
            builder.append("%d".formatted(this.parameterNamesLengths[i]));
        }
        ArrayDataType stateMachineArray = new ArrayDataType(BYTE, this.stateMachineOpcodes.length, BYTE.getLength());
        structure.add((DataType)stateMachineArray, "state_machine", null);
        structure.setCategoryPath(new CategoryPath("/dex/debug_info_item"));
        try {
            structure.setName(builder.toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return structure;
    }
}

