/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.dex.format;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.file.formats.android.dex.format.MapItem;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class MapList
implements StructConverter {
    private int size;
    private List<MapItem> items = new ArrayList<MapItem>();

    public MapList(BinaryReader reader) throws IOException {
        this.size = reader.readNextInt();
        for (int i = 0; i < this.size; ++i) {
            this.items.add(new MapItem(reader));
        }
    }

    public int getSize() {
        return this.size;
    }

    public List<MapItem> getItems() {
        return Collections.unmodifiableList(this.items);
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType structure = new StructureDataType("MapList_" + this.size, 0);
        structure.add(DWORD, "size", null);
        int index = 0;
        for (MapItem item : this.items) {
            structure.add(item.toDataType(), "item_" + index++, null);
        }
        structure.setCategoryPath(new CategoryPath("/dex"));
        return structure;
    }
}

