/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.dex.format;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.StructConverterUtil;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class MethodIDItem
implements StructConverter {
    private long _fileOffset;
    private short classIndex;
    private short protoIndex;
    private int nameIndex;

    public MethodIDItem(BinaryReader reader) throws IOException {
        this._fileOffset = reader.getPointerIndex();
        this.classIndex = reader.readNextShort();
        this.protoIndex = reader.readNextShort();
        this.nameIndex = reader.readNextInt();
    }

    public long getFileOffset() {
        return this._fileOffset;
    }

    public int getClassIndex() {
        return this.classIndex;
    }

    public short getProtoIndex() {
        return this.protoIndex;
    }

    public int getNameIndex() {
        return this.nameIndex;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        DataType dataType = StructConverterUtil.toDataType(MethodIDItem.class);
        dataType.setCategoryPath(new CategoryPath("/dex"));
        return dataType;
    }
}

