/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.oat.tlt;

import ghidra.app.util.bin.BinaryReader;
import ghidra.file.formats.android.oat.tlt.TypeLookupTable;
import ghidra.file.formats.android.oat.tlt.TypeLookupTableEntry;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class TypeLookupTable_Nougat
extends TypeLookupTable {
    private int dex_file_;
    private int mask_;
    private int entries_;
    private int owns_entries_;
    private List<TypeLookupTableEntry> entryList = new ArrayList<TypeLookupTableEntry>();

    public TypeLookupTable_Nougat(BinaryReader reader) throws IOException {
        this.dex_file_ = reader.readNextInt();
        this.mask_ = reader.readNextInt();
        this.entries_ = reader.readNextInt();
        this.owns_entries_ = reader.readNextInt();
    }

    public int getDexFile() {
        return this.dex_file_;
    }

    public int getMask() {
        return this.mask_;
    }

    public int getEntries() {
        return this.entries_;
    }

    public boolean isOwnsEntries() {
        return this.owns_entries_ == 0;
    }

    public List<TypeLookupTableEntry> getEntryList() {
        return this.entryList;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType structure = new StructureDataType(TypeLookupTable_Nougat.class.getSimpleName() + "_" + this.entryList.size(), 0);
        structure.add(DWORD, "dex_file_", null);
        structure.add(DWORD, "mask_", null);
        structure.add(DWORD, "entries_", null);
        structure.add(DWORD, "owns_entries_", null);
        structure.setCategoryPath(new CategoryPath("/oat"));
        return structure;
    }
}

