/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.cart;

import java.io.IOException;
import java.io.InputStream;

public abstract class CartV1StreamProcessor
extends InputStream {
    protected static final int DEFAULT_BUFFER_SIZE = 65536;
    protected InputStream delegate;
    protected byte[] currentChunk;
    protected int chunkPos;

    public CartV1StreamProcessor(InputStream delegate) {
        this.delegate = delegate;
    }

    @Override
    public int read() throws IOException {
        if (!this.ensureChunkAvailable()) {
            return -1;
        }
        byte b = this.currentChunk[this.chunkPos];
        ++this.chunkPos;
        return Byte.toUnsignedInt(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (!this.ensureChunkAvailable()) {
            return -1;
        }
        int bytesAvail = this.currentChunk.length - this.chunkPos;
        int bytesToCopy = Math.min(len, bytesAvail);
        System.arraycopy(this.currentChunk, this.chunkPos, b, off, bytesToCopy);
        this.chunkPos += bytesToCopy;
        return bytesToCopy;
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    protected abstract boolean readNextChunk() throws IOException;

    private boolean ensureChunkAvailable() throws IOException {
        return this.currentChunk == null || this.chunkPos >= this.currentChunk.length ? this.readNextChunk() : true;
    }
}

