/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.squashfs;

import ghidra.app.util.bin.BinaryReader;
import ghidra.file.formats.squashfs.SquashInode;
import ghidra.file.formats.squashfs.SquashSuperBlock;
import java.io.IOException;

public class SquashBasicDirectoryInode
extends SquashInode {
    protected long blockIndex;
    protected long hardLinkCount;
    protected long uncompressedFileSize;
    protected int blockOffset;
    protected int parentInodeNumber;
    protected boolean parentIsRoot = false;

    public SquashBasicDirectoryInode(BinaryReader reader, SquashSuperBlock superBlock, boolean isExtended) throws IOException {
        super(reader, superBlock);
        if (isExtended) {
            return;
        }
        this.blockIndex = reader.readNextUnsignedInt();
        this.hardLinkCount = reader.readNextUnsignedInt();
        this.uncompressedFileSize = reader.readNextUnsignedShort();
        this.blockOffset = reader.readNextUnsignedShort();
        this.parentInodeNumber = reader.readNextUnsignedIntExact();
        this.parentIsRoot = (long)this.parentInodeNumber == superBlock.getInodeCount() + 1L;
    }

    public int getParentInodeNumber() {
        return this.parentInodeNumber;
    }

    public boolean isParentRoot() {
        return this.parentIsRoot;
    }

    public long getIndex() {
        return this.blockIndex;
    }

    public long getHardLinkCount() {
        return this.hardLinkCount;
    }

    public int getOffset() {
        return this.blockOffset;
    }

    public long getUncompressedSize() {
        return this.uncompressedFileSize;
    }
}

