/*
 * Decompiled with CFR 0.152.
 */
package generic.theme;

import generic.theme.AbstractThemeReader;
import generic.theme.GTheme;
import generic.theme.LafType;
import ghidra.framework.Application;
import ghidra.util.Msg;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.FileUtils;

class ThemeReader
extends AbstractThemeReader {
    private File file;
    private GTheme theme;

    ThemeReader(File file) throws IOException {
        super(file.getAbsolutePath());
        this.file = file;
    }

    public GTheme readTheme() throws IOException {
        if (this.file.getName().endsWith(GTheme.FILE_EXTENSION)) {
            return this.readFileTheme();
        }
        if (this.file.getName().endsWith(GTheme.ZIP_FILE_EXTENSION)) {
            return this.readZipTheme();
        }
        throw new IOException("Imported File must end in either " + GTheme.FILE_EXTENSION + " or " + GTheme.ZIP_FILE_EXTENSION);
    }

    private GTheme readFileTheme() throws IOException {
        try (FileReader reader = new FileReader(this.file);){
            this.read(reader);
        }
        if (this.theme == null) {
            throw new IOException("Invalid Theme file: " + String.valueOf(this.file));
        }
        return this.theme;
    }

    private GTheme readZipTheme() throws IOException {
        try (ZipFile zipFile = new ZipFile(this.file);){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String name = entry.getName();
                InputStream is = zipFile.getInputStream(entry);
                try {
                    if (name.endsWith(".theme")) {
                        this.processThemeData(name, is);
                        continue;
                    }
                    this.processIconFile(name, is);
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
        }
        return this.theme;
    }

    GTheme readTheme(Reader reader) throws IOException {
        this.read(reader);
        return this.theme;
    }

    @Override
    protected void processNoSection(AbstractThemeReader.Section section) throws IOException {
        String themeName = section.getValue("name");
        if (themeName == null) {
            throw new IOException("Missing theme name!");
        }
        String lookAndFeelName = section.getValue("lookAndFeel");
        LafType lookAndFeel = LafType.fromName(lookAndFeelName);
        if (lookAndFeel == null) {
            throw new IOException("Invalid or missing lookAndFeel name: \"" + lookAndFeelName + "\"");
        }
        boolean isDark = Boolean.valueOf(section.getValue("useDarkDefaults"));
        this.theme = new GTheme(this.file, themeName, lookAndFeel, isDark);
        section.remove("name");
        section.remove("lookAndFeel");
        section.remove("useDarkDefaults");
        this.processValues(this.theme, section);
    }

    @Override
    protected void processDefaultSection(AbstractThemeReader.Section section) throws IOException {
        this.error(section.getLineNumber(), "[Defaults] section not allowed in theme files!");
    }

    @Override
    protected void processDarkDefaultSection(AbstractThemeReader.Section section) throws IOException {
        this.error(section.getLineNumber(), "[Dark Defaults] section not allowed in theme files!");
    }

    @Override
    protected void processCustomSection(AbstractThemeReader.Section section) throws IOException {
        this.error(section.getLineNumber(), "Custom sections not allowed in theme files! " + section.getName());
    }

    private void processIconFile(String path, InputStream is) throws IOException {
        int indexOf = path.indexOf("images/");
        if (indexOf < 0) {
            Msg.error((Object)this, (Object)("Unknown file: " + path));
        }
        String relativePath = path.substring(indexOf, path.length());
        File dir = Application.getUserSettingsDirectory();
        File iconFile = new File(dir, relativePath);
        FileUtils.copyInputStreamToFile((InputStream)is, (File)iconFile);
    }

    private void processThemeData(String name, InputStream is) throws IOException {
        InputStreamReader reader = new InputStreamReader(is);
        this.read(reader);
    }
}

