/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.control;

import ghidra.debug.api.target.Target;
import ghidra.framework.plugintool.PluginTool;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskMonitor;
import java.util.Collection;
import java.util.List;

public class DisconnectTask
extends Task {
    private final PluginTool tool;
    private final List<Target> targets;

    public DisconnectTask(PluginTool tool, Collection<Target> targets) {
        super("Disconnect", false, true, false);
        this.tool = tool;
        this.targets = List.copyOf(targets);
    }

    public void run(TaskMonitor monitor) throws CancelledException {
        monitor.initialize((long)this.targets.size(), "Disconnecting...");
        for (Target target : this.targets) {
            try {
                monitor.setMessage("Disconnecting " + target.describe());
                target.disconnect();
                monitor.increment();
            }
            catch (Exception e) {
                this.tool.setStatusInfo("Disconnect failed: " + String.valueOf(e), true);
                Msg.error((Object)((Object)this), (Object)("Disconnect failed: " + String.valueOf(e)), (Throwable)e);
            }
        }
    }
}

