/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.control;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.KeyBindingType;
import ghidra.app.plugin.core.debug.gui.control.TargetActionTask;
import ghidra.app.services.DebuggerTraceManagerService;
import ghidra.debug.api.target.ActionName;
import ghidra.debug.api.target.Target;
import ghidra.framework.plugintool.PluginTool;
import java.util.Comparator;

class TargetDockingAction
extends DockingAction {
    private final PluginTool tool;
    private final ActionName action;
    private final String defaultDescription;
    private Target.ActionEntry entry;

    public TargetDockingAction(String name, String owner, KeyBindingType keyBindingType, PluginTool tool, ActionName action, String defaultDescription) {
        super(name, owner, keyBindingType);
        this.tool = tool;
        this.action = action;
        this.defaultDescription = defaultDescription;
    }

    private Target.ActionEntry findEntry(ActionContext context) {
        DebuggerTraceManagerService traceManager = (DebuggerTraceManagerService)this.tool.getService(DebuggerTraceManagerService.class);
        if (traceManager == null) {
            return null;
        }
        Target target = traceManager.getCurrent().getTarget();
        if (target == null) {
            return null;
        }
        return target.collectActions(this.action, context, Target.ObjectArgumentPolicy.CURRENT_AND_RELATED).values().stream().filter(e -> !e.requiresPrompt()).sorted(Comparator.comparing(e -> -e.specificity())).findFirst().orElse(null);
    }

    protected void updateFromContext(ActionContext context) {
        this.entry = this.findEntry(context);
        if (this.entry == null) {
            this.getToolBarData().setIcon(this.action.icon());
            this.setDescription(this.defaultDescription);
        } else {
            this.getToolBarData().setIcon(this.entry.icon());
            this.setDescription(this.entry.details());
        }
    }

    public boolean isEnabledForContext(ActionContext context) {
        this.updateFromContext(context);
        return this.entry != null && this.entry.isEnabled();
    }

    public void actionPerformed(ActionContext context) {
        if (this.entry == null) {
            return;
        }
        TargetActionTask.runAction(this.tool, this.getName(), this.entry);
    }
}

