/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.listing;

import docking.ActionContext;
import docking.action.ActionContextProvider;
import docking.action.DockingActionIf;
import docking.action.MenuData;
import docking.widgets.fieldpanel.support.BackgroundColorModel;
import ghidra.app.events.ProgramActivatedPluginEvent;
import ghidra.app.events.ProgramClosedPluginEvent;
import ghidra.app.events.TreeSelectionPluginEvent;
import ghidra.app.events.ViewChangedPluginEvent;
import ghidra.app.plugin.core.codebrowser.AbstractCodeBrowserPlugin;
import ghidra.app.plugin.core.codebrowser.CodeViewerProvider;
import ghidra.app.plugin.core.debug.event.TraceActivatedPluginEvent;
import ghidra.app.plugin.core.debug.event.TraceClosedPluginEvent;
import ghidra.app.plugin.core.debug.event.TraceHighlightPluginEvent;
import ghidra.app.plugin.core.debug.event.TraceLocationPluginEvent;
import ghidra.app.plugin.core.debug.event.TraceSelectionPluginEvent;
import ghidra.app.plugin.core.debug.event.TrackingChangedPluginEvent;
import ghidra.app.plugin.core.debug.gui.DebuggerResources;
import ghidra.app.plugin.core.debug.gui.action.DebuggerProgramLocationActionContext;
import ghidra.app.plugin.core.debug.gui.action.NoneLocationTrackingSpec;
import ghidra.app.plugin.core.debug.gui.listing.CursorBackgroundColorModel;
import ghidra.app.plugin.core.debug.gui.listing.DebuggerListingProvider;
import ghidra.app.plugin.core.debug.gui.listing.MemoryStateListingBackgroundColorModel;
import ghidra.app.services.ClipboardService;
import ghidra.app.services.DebuggerEmulationService;
import ghidra.app.services.DebuggerListingService;
import ghidra.app.services.DebuggerStaticMappingService;
import ghidra.app.services.DebuggerTraceManagerService;
import ghidra.app.services.MarkerService;
import ghidra.app.services.ProgramManager;
import ghidra.app.services.ViewManagerService;
import ghidra.app.util.viewer.format.FormatManager;
import ghidra.app.util.viewer.listingpanel.ListingPanel;
import ghidra.debug.api.action.AutoReadMemorySpec;
import ghidra.debug.api.action.LocationTrackingSpec;
import ghidra.debug.api.listing.MultiBlendedListingBackgroundColorModel;
import ghidra.debug.api.tracemgr.DebuggerCoordinates;
import ghidra.framework.options.SaveState;
import ghidra.framework.plugintool.AutoService;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.annotation.AutoServiceConsumed;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramSelection;
import ghidra.trace.model.program.TraceProgramView;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.jdom.Element;

@PluginInfo(shortDescription="View and annotate listings of trace (possibly live) memory", description="Provides the memory listing display window. Functions similarly to the main program listing display window, but for traces. If the trace is the destination of a live recording, the view(s) retrieve live memory on demand.", category="Debugger", packageName="Debugger", status=PluginStatus.RELEASED, eventsConsumed={ProgramClosedPluginEvent.class, TraceActivatedPluginEvent.class, TraceClosedPluginEvent.class, TraceLocationPluginEvent.class, TraceSelectionPluginEvent.class, TraceHighlightPluginEvent.class, TrackingChangedPluginEvent.class}, eventsProduced={TraceLocationPluginEvent.class, TraceSelectionPluginEvent.class, TraceHighlightPluginEvent.class, TrackingChangedPluginEvent.class}, servicesRequired={DebuggerStaticMappingService.class, DebuggerEmulationService.class, ProgramManager.class, ClipboardService.class, MarkerService.class}, servicesProvided={DebuggerListingService.class})
public class DebuggerListingPlugin
extends AbstractCodeBrowserPlugin<DebuggerListingProvider>
implements DebuggerListingService {
    private static final String KEY_CONNECTED_PROVIDER = "connectedProvider";
    private static final String KEY_DISCONNECTED_COUNT = "disconnectedCount";
    private static final String PREFIX_DISCONNECTED_PROVIDER = "disconnectedProvider";
    protected NewListingAction actionNewListing;
    @AutoServiceConsumed
    private ProgramManager programManager;
    private AutoService.Wiring autoServiceWiring;
    private DebuggerCoordinates current = DebuggerCoordinates.NOWHERE;

    public DebuggerListingPlugin(PluginTool tool) {
        super(tool);
        this.autoServiceWiring = AutoService.wireServicesProvidedAndConsumed((Plugin)this);
        this.createActions();
        tool.registerDefaultContextProvider(DebuggerProgramLocationActionContext.class, (ActionContextProvider)this.connectedProvider);
    }

    protected void dispose() {
        this.tool.unregisterDefaultContextProvider(DebuggerProgramLocationActionContext.class, (ActionContextProvider)this.connectedProvider);
        super.dispose();
    }

    public MultiBlendedListingBackgroundColorModel createListingBackgroundColorModel(ListingPanel listingPanel) {
        MultiBlendedListingBackgroundColorModel colorModel = new MultiBlendedListingBackgroundColorModel();
        colorModel.addModel((BackgroundColorModel)new MemoryStateListingBackgroundColorModel(listingPanel));
        colorModel.addModel((BackgroundColorModel)new CursorBackgroundColorModel((Plugin)this, listingPanel));
        return colorModel;
    }

    protected DebuggerListingProvider createProvider(FormatManager formatManager, boolean isConnected) {
        return new DebuggerListingProvider(this, formatManager, isConnected);
    }

    private void createActions() {
        this.actionNewListing = new NewListingAction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DebuggerListingProvider createListingIfMissing(LocationTrackingSpec spec, boolean followsCurrentThread) {
        List list = this.disconnectedProviders;
        synchronized (list) {
            for (DebuggerListingProvider provider : this.disconnectedProviders) {
                if (provider.getTrackingSpec() != spec || provider.isFollowsCurrentThread() != followsCurrentThread) continue;
                return provider;
            }
            DebuggerListingProvider provider = (DebuggerListingProvider)this.createNewDisconnectedProvider();
            provider.setTrackingSpec(spec);
            provider.setFollowsCurrentThread(followsCurrentThread);
            provider.goToCoordinates(this.current);
            return provider;
        }
    }

    protected void setView(AddressSetView addrSet) {
        TraceProgramView view = this.current.getView();
        if (view == null) {
            super.setView((AddressSetView)new AddressSet());
        } else {
            super.setView((AddressSetView)view.getMemory());
        }
    }

    protected void updateBackgroundColorModel() {
    }

    public void locationChanged(CodeViewerProvider provider, ProgramLocation location) {
        if (provider == this.connectedProvider) {
            this.firePluginEvent((PluginEvent)new TraceLocationPluginEvent(this.getName(), location));
        }
    }

    public void selectionChanged(CodeViewerProvider provider, ProgramSelection selection) {
        if (provider != this.connectedProvider) {
            return;
        }
        TraceProgramView view = this.current.getView();
        if (view == null) {
            return;
        }
        this.firePluginEvent((PluginEvent)new TraceSelectionPluginEvent(this.getName(), selection, view));
    }

    public void highlightChanged(CodeViewerProvider provider, ProgramSelection highlight) {
        if (provider != this.connectedProvider) {
            return;
        }
        TraceProgramView view = this.current.getView();
        if (view == null) {
            return;
        }
        this.firePluginEvent((PluginEvent)new TraceHighlightPluginEvent(this.getName(), highlight, view));
    }

    protected boolean heedLocationEvent(PluginEvent ev) {
        PluginEvent trigger = ev.getTriggerEvent();
        if (trigger instanceof TraceActivatedPluginEvent) {
            return false;
        }
        if (trigger instanceof ProgramActivatedPluginEvent) {
            return false;
        }
        if (trigger instanceof TreeSelectionPluginEvent) {
            return false;
        }
        return !(trigger instanceof ViewChangedPluginEvent);
    }

    protected boolean heedSelectionEvent(PluginEvent ev) {
        return this.heedLocationEvent(ev);
    }

    public void processEvent(PluginEvent event) {
        PluginEvent pluginEvent = event;
        Objects.requireNonNull(pluginEvent);
        PluginEvent pluginEvent2 = pluginEvent;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ProgramClosedPluginEvent.class, TraceActivatedPluginEvent.class, TraceClosedPluginEvent.class, TraceLocationPluginEvent.class, TraceSelectionPluginEvent.class, TraceHighlightPluginEvent.class, TrackingChangedPluginEvent.class}, (Object)pluginEvent2, n)) {
            case 0: {
                ProgramClosedPluginEvent ev = (ProgramClosedPluginEvent)pluginEvent2;
                this.allProviders(p -> p.programClosed(ev.getProgram()));
                break;
            }
            case 1: {
                TraceActivatedPluginEvent ev = (TraceActivatedPluginEvent)pluginEvent2;
                this.current = ev.getActiveCoordinates();
                this.allProviders(p -> p.coordinatesActivated(this.current));
                break;
            }
            case 2: {
                TraceClosedPluginEvent ev = (TraceClosedPluginEvent)pluginEvent2;
                if (this.current.getTrace() == ev.getTrace()) {
                    this.current = DebuggerCoordinates.NOWHERE;
                }
                this.allProviders(p -> p.traceClosed(ev.getTrace()));
                break;
            }
            case 3: {
                TraceLocationPluginEvent ev = (TraceLocationPluginEvent)pluginEvent2;
                ((DebuggerListingProvider)this.connectedProvider).goTo((Program)ev.getTraceProgramView(), ev.getLocation());
                break;
            }
            case 4: {
                TraceSelectionPluginEvent ev = (TraceSelectionPluginEvent)pluginEvent2;
                if (ev.getTraceProgramView() != this.current.getView()) break;
                ((DebuggerListingProvider)this.connectedProvider).setSelection(ev.getSelection());
                break;
            }
            case 5: {
                TraceHighlightPluginEvent ev = (TraceHighlightPluginEvent)pluginEvent2;
                if (ev.getTraceProgramView() != this.current.getView()) break;
                ((DebuggerListingProvider)this.connectedProvider).setHighlight(ev.getHighlight());
                break;
            }
            case 6: {
                TrackingChangedPluginEvent ev = (TrackingChangedPluginEvent)pluginEvent2;
                ((DebuggerListingProvider)this.connectedProvider).setTrackingSpec(ev.getLocationTrackingSpec());
                break;
            }
        }
    }

    protected void allProviders(Consumer<DebuggerListingProvider> action) {
        action.accept((DebuggerListingProvider)this.connectedProvider);
        for (DebuggerListingProvider provider : this.disconnectedProviders) {
            action.accept(provider);
        }
    }

    @AutoServiceConsumed
    public void setTraceManager(DebuggerTraceManagerService traceManager) {
        DebuggerListingProvider provider = (DebuggerListingProvider)this.connectedProvider;
        if (provider == null || traceManager == null) {
            return;
        }
        this.current = traceManager.getCurrent();
        provider.coordinatesActivated(this.current);
    }

    public void setTrackingSpec(LocationTrackingSpec spec) {
        ((DebuggerListingProvider)this.connectedProvider).setTrackingSpec(spec);
    }

    public LocationTrackingSpec getTrackingSpec() {
        return ((DebuggerListingProvider)this.connectedProvider).getTrackingSpec();
    }

    public void addTrackingSpecChangeListener(DebuggerListingService.LocationTrackingSpecChangeListener listener) {
        ((DebuggerListingProvider)this.connectedProvider).addTrackingSpecChangeListener(listener);
    }

    public void removeTrackingSpecChangeListener(DebuggerListingService.LocationTrackingSpecChangeListener listener) {
        ((DebuggerListingProvider)this.connectedProvider).removeTrackingSpecChangeListener(listener);
    }

    public AutoReadMemorySpec getAutoReadMemorySpec() {
        return ((DebuggerListingProvider)this.connectedProvider).getAutoReadMemorySpec();
    }

    public void setCurrentSelection(ProgramSelection selection) {
        ((DebuggerListingProvider)this.connectedProvider).setSelection(selection);
    }

    public boolean goTo(Address address, boolean centerOnScreen) {
        TraceProgramView view = ((DebuggerListingProvider)this.connectedProvider).current.getView();
        if (view == null) {
            return false;
        }
        ProgramLocation loc = new ProgramLocation((Program)view, address);
        return this.goTo(loc, centerOnScreen);
    }

    public Object getTransientState() {
        return new Object[0];
    }

    public void restoreTransientState(Object objectState) {
    }

    public void writeDataState(SaveState saveState) {
        SaveState connectedProviderState = new SaveState();
        ((DebuggerListingProvider)this.connectedProvider).writeDataState(connectedProviderState);
        saveState.putXmlElement(KEY_CONNECTED_PROVIDER, connectedProviderState.saveToXml());
        List disconnected = this.disconnectedProviders.stream().filter(p -> p.isFollowsCurrentThread()).collect(Collectors.toList());
        for (DebuggerListingProvider p2 : this.disconnectedProviders) {
            if (disconnected.contains((Object)p2)) continue;
            disconnected.add(p2);
        }
        int disconnectedCount = disconnected.size();
        saveState.putInt(KEY_DISCONNECTED_COUNT, disconnectedCount);
        for (int index = 0; index < disconnectedCount; ++index) {
            DebuggerListingProvider provider = (DebuggerListingProvider)((Object)disconnected.get(index));
            String stateName = PREFIX_DISCONNECTED_PROVIDER + index;
            SaveState providerState = new SaveState();
            provider.writeDataState(providerState);
            saveState.putXmlElement(stateName, providerState.saveToXml());
        }
    }

    protected void ensureProviders(int count, boolean followCurrentThread, SaveState configState) {
        while (this.disconnectedProviders.size() < count) {
            int index = this.disconnectedProviders.size();
            String stateName = PREFIX_DISCONNECTED_PROVIDER + index;
            DebuggerListingProvider provider = (DebuggerListingProvider)this.createNewDisconnectedProvider();
            provider.setFollowsCurrentThread(false);
            Element providerElement = configState.getXmlElement(stateName);
            if (providerElement != null) {
                SaveState providerState = new SaveState(providerElement);
                provider.readConfigState(providerState);
                continue;
            }
            provider.setTrackingSpec(NoneLocationTrackingSpec.INSTANCE);
        }
    }

    public void readDataState(SaveState saveState) {
        Element connectedProviderElement = saveState.getXmlElement(KEY_CONNECTED_PROVIDER);
        if (connectedProviderElement != null) {
            SaveState connectedProviderState = new SaveState(connectedProviderElement);
            ((DebuggerListingProvider)this.connectedProvider).readDataState(connectedProviderState);
        }
        int disconnectedCount = saveState.getInt(KEY_DISCONNECTED_COUNT, 0);
        this.ensureProviders(disconnectedCount, false, saveState);
        List disconnected = this.disconnectedProviders;
        for (int index = 0; index < disconnectedCount; ++index) {
            String stateName = PREFIX_DISCONNECTED_PROVIDER + index;
            Element providerElement = saveState.getXmlElement(stateName);
            if (providerElement == null) continue;
            SaveState providerState = new SaveState(providerElement);
            DebuggerListingProvider provider = (DebuggerListingProvider)((Object)disconnected.get(index));
            provider.readDataState(providerState);
        }
    }

    public void writeConfigState(SaveState saveState) {
        SaveState connectedProviderState = new SaveState();
        ((DebuggerListingProvider)this.connectedProvider).writeConfigState(connectedProviderState);
        saveState.putXmlElement(KEY_CONNECTED_PROVIDER, connectedProviderState.saveToXml());
        List disconnected = this.disconnectedProviders.stream().filter(p -> p.isFollowsCurrentThread()).collect(Collectors.toList());
        int disconnectedCount = disconnected.size();
        saveState.putInt(KEY_DISCONNECTED_COUNT, disconnectedCount);
        for (int index = 0; index < disconnectedCount; ++index) {
            DebuggerListingProvider provider = (DebuggerListingProvider)((Object)disconnected.get(index));
            String stateName = PREFIX_DISCONNECTED_PROVIDER + index;
            SaveState providerState = new SaveState();
            provider.writeConfigState(providerState);
            saveState.putXmlElement(stateName, providerState.saveToXml());
        }
    }

    public void readConfigState(SaveState saveState) {
        Element connectedProviderElement = saveState.getXmlElement(KEY_CONNECTED_PROVIDER);
        if (connectedProviderElement != null) {
            SaveState connectedProviderState = new SaveState(connectedProviderElement);
            ((DebuggerListingProvider)this.connectedProvider).readConfigState(connectedProviderState);
        }
        int disconnectedCount = saveState.getInt(KEY_DISCONNECTED_COUNT, 0);
        this.ensureProviders(disconnectedCount, true, saveState);
    }

    public ViewManagerService getViewManager(CodeViewerProvider codeViewerProvider) {
        return null;
    }

    protected class NewListingAction
    extends DebuggerResources.AbstractNewListingAction {
        public static final String GROUP = "Dbg3a. Transient Views";

        public NewListingAction() {
            super((Plugin)DebuggerListingPlugin.this);
            this.setMenuBarData(new MenuData(new String[]{"Window", "Debugger", "New Dynamic Listing"}, ICON, GROUP));
            DebuggerListingPlugin.this.tool.addAction((DockingActionIf)this);
            this.setEnabled(true);
        }

        public void actionPerformed(ActionContext context) {
            DebuggerListingPlugin.this.createNewDisconnectedProvider();
        }
    }
}

