/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.memview;

public class MemviewMap {
    private long max;
    private long sz;
    private double elementsPerPixel;
    private double multiplier;

    public MemviewMap(long elems, long pixels) {
        this.max = this.sz = elems;
        this.elementsPerPixel = pixels == 0L ? 0.0 : (double)(elems / pixels);
        this.multiplier = 1.0;
    }

    public void createMapping(double mult) {
        this.multiplier = mult;
    }

    public long getOffset(int pixel) {
        return Math.round((double)pixel * this.elementsPerPixel / this.multiplier);
    }

    public int getPixel(long offset) {
        if (offset < 0L) {
            offset = this.max;
        }
        double doffset = (double)offset * this.multiplier / this.elementsPerPixel;
        return (int)Math.round(doffset);
    }

    public long getSize() {
        return this.getPixel(this.max);
    }

    public double getMultiplier() {
        return this.multiplier;
    }

    public double getOriginalElemPerPixel() {
        return this.elementsPerPixel;
    }
}

