/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.register;

import ghidra.program.model.lang.Register;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;

public class AvailableRegisterRow {
    private final int number;
    private final Register register;
    private final String contains;
    private boolean known;
    private boolean selected;

    public AvailableRegisterRow(int number, Register register) {
        this.number = number;
        this.register = register;
        this.contains = this.computeContains();
    }

    protected String computeContains() {
        TreeSet<String> descendants = new TreeSet<String>();
        this.collectChildren(this.register, descendants);
        return StringUtils.join(descendants, (String)", ");
    }

    protected void collectChildren(Register reg, Set<String> set) {
        for (Register child : reg.getChildRegisters()) {
            set.add(child.getName());
            this.collectChildren(child, set);
        }
    }

    public Register getRegister() {
        return this.register;
    }

    public int getNumber() {
        return this.number;
    }

    public String getName() {
        return this.register.getName();
    }

    public int getBits() {
        return this.register.getBitLength();
    }

    public String getGroup() {
        String group = this.register.getGroup();
        if (group == null) {
            return "(none)";
        }
        return group;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean select) {
        this.selected = select;
    }

    public boolean isKnown() {
        return this.known;
    }

    public void setKnown(boolean known) {
        this.known = known;
    }

    public String getContains() {
        return this.contains;
    }

    public String getParentName() {
        Register base = this.register.getBaseRegister();
        if (base == this.register || base == null) {
            return "";
        }
        return base.getName();
    }
}

