/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.platform.dbgeng;

import ghidra.app.plugin.core.debug.disassemble.DisassemblyInject;
import ghidra.app.plugin.core.debug.gui.DebuggerResources;
import ghidra.app.plugin.core.debug.gui.action.PCLocationTrackingSpec;
import ghidra.app.plugin.core.debug.mapping.AbstractDebuggerPlatformOpinion;
import ghidra.app.plugin.core.debug.mapping.DebuggerPlatformOffer;
import ghidra.app.plugin.core.debug.mapping.DefaultDebuggerPlatformMapper;
import ghidra.app.plugin.core.debug.platform.dbgeng.DbgengX64DisassemblyInject;
import ghidra.app.services.DebuggerConsoleService;
import ghidra.app.services.DebuggerListingService;
import ghidra.app.services.DebuggerTargetService;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.MemBufferByteProvider;
import ghidra.app.util.bin.format.pe.NTHeader;
import ghidra.app.util.bin.format.pe.OptionalHeader;
import ghidra.app.util.bin.format.pe.PortableExecutable;
import ghidra.debug.api.action.AutoReadMemorySpec;
import ghidra.debug.api.platform.DebuggerPlatformMapper;
import ghidra.debug.api.target.Target;
import ghidra.debug.api.tracemgr.DebuggerCoordinates;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.CompilerSpecID;
import ghidra.program.model.lang.Endian;
import ghidra.program.model.lang.LanguageID;
import ghidra.program.model.mem.MemBuffer;
import ghidra.trace.model.Trace;
import ghidra.trace.model.guest.TracePlatform;
import ghidra.trace.model.modules.TraceModule;
import ghidra.trace.model.target.TraceObject;
import ghidra.util.Msg;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;

public class DbgengDebuggerPlatformOpinion
extends AbstractDebuggerPlatformOpinion {
    protected static final LanguageID LANG_ID_X86_64 = new LanguageID("x86:LE:64:default");
    protected static final LanguageID LANG_ID_X86_64_32 = new LanguageID("x86:LE:64:compat32");
    protected static final CompilerSpecID COMP_ID_VS = new CompilerSpecID("windows");
    protected static final Set<DisassemblyInject> INJECTS = Set.of(new DbgengX64DisassemblyInject());

    @Override
    protected Set<DebuggerPlatformOffer> getOffers(TraceObject object, long snap, TraceObject env, String debugger, String arch, String os, Endian endian, boolean includeOverrides) {
        boolean is64Bit;
        if (debugger == null || arch == null || !debugger.toLowerCase().contains("dbg")) {
            return Set.of();
        }
        boolean bl = is64Bit = arch.contains("x86_64") || arch.contains("x64_32");
        if (!is64Bit) {
            return Set.of();
        }
        return Set.of(Offer.X64, Offer.X64_32, Offer.WOW64);
    }

    static enum Offer implements DebuggerPlatformOffer
    {
        X64{

            @Override
            public String getDescription() {
                return "Dbgeng x64 (64-bit module)";
            }

            @Override
            public int getConfidence() {
                return 10010;
            }

            @Override
            public CompilerSpec getCompilerSpec() {
                return this.getCompilerSpec(LANG_ID_X86_64, COMP_ID_VS);
            }

            @Override
            public DebuggerPlatformMapper take(PluginTool tool, Trace trace) {
                return new DbgengX64DebuggerPlatformMapper(tool, trace, this.getCompilerSpec());
            }

            @Override
            public boolean isCreatorOf(DebuggerPlatformMapper mapper) {
                return mapper.getClass() == DbgengX64DebuggerPlatformMapper.class;
            }
        }
        ,
        X64_32{

            @Override
            public String getDescription() {
                return "Dbgeng x64 (32-bit module)";
            }

            @Override
            public int getConfidence() {
                return 10010;
            }

            @Override
            public CompilerSpec getCompilerSpec() {
                return this.getCompilerSpec(LANG_ID_X86_64_32, COMP_ID_VS);
            }

            @Override
            public DebuggerPlatformMapper take(PluginTool tool, Trace trace) {
                return new DbgengX64_32DebuggerPlatformMapper(tool, trace, this.getCompilerSpec());
            }

            @Override
            public boolean isCreatorOf(DebuggerPlatformMapper mapper) {
                return mapper.getClass() == DbgengX64_32DebuggerPlatformMapper.class;
            }
        }
        ,
        WOW64{

            @Override
            public String getDescription() {
                return "Dbgeng x64 (WoW64)";
            }

            @Override
            public int getConfidence() {
                return 10020;
            }

            @Override
            public CompilerSpec getCompilerSpec() {
                return this.getCompilerSpec(LANG_ID_X86_64_32, COMP_ID_VS);
            }

            @Override
            public DebuggerPlatformMapper take(PluginTool tool, Trace trace) {
                return new DbgengWoW64DebuggerPlatformMapper(tool, trace, this.getCompilerSpec());
            }

            @Override
            public boolean isCreatorOf(DebuggerPlatformMapper mapper) {
                return mapper.getClass() == DbgengWoW64DebuggerPlatformMapper.class;
            }
        };

    }

    protected static class DbgengWoW64DebuggerPlatformMapper
    extends AbstractDbgengX64DebuggerPlatformMapper {
        public DbgengWoW64DebuggerPlatformMapper(PluginTool tool, Trace trace, CompilerSpec cSpec) {
            super(tool, trace, cSpec);
        }

        @Override
        public TracePlatform addToTrace(TraceObject newFocus, long snap) {
            DebuggerCoordinates coords = DebuggerCoordinates.NOWHERE.object(newFocus).snap(snap);
            Address pc = PCLocationTrackingSpec.INSTANCE.computeTraceAddress((ServiceProvider)this.tool, coords);
            if (pc == null) {
                return this.addOrGetPlatform(Offer.X64_32.getCompilerSpec(), snap);
            }
            Offer sel = switch (Mode.computeFor(this.tool, this.trace, pc, snap).ordinal()) {
                case 0 -> Offer.X64;
                default -> Offer.X64_32;
            };
            return this.addOrGetPlatform(sel.getCompilerSpec(), snap);
        }
    }

    protected static class DbgengX64_32DebuggerPlatformMapper
    extends AbstractDbgengX64DebuggerPlatformMapper {
        public DbgengX64_32DebuggerPlatformMapper(PluginTool tool, Trace trace, CompilerSpec cSpec) {
            super(tool, trace, cSpec);
        }
    }

    protected static class DbgengX64DebuggerPlatformMapper
    extends AbstractDbgengX64DebuggerPlatformMapper {
        public DbgengX64DebuggerPlatformMapper(PluginTool tool, Trace trace, CompilerSpec cSpec) {
            super(tool, trace, cSpec);
        }
    }

    protected static abstract class AbstractDbgengX64DebuggerPlatformMapper
    extends DefaultDebuggerPlatformMapper {
        public AbstractDbgengX64DebuggerPlatformMapper(PluginTool tool, Trace trace, CompilerSpec cSpec) {
            super(tool, trace, cSpec);
        }

        @Override
        protected TracePlatform getDisassemblyPlatform(TraceObject object, Address start, long snap) {
            CompilerSpec x64cs = Offer.X64.getCompilerSpec();
            return this.addOrGetPlatform(x64cs, snap);
        }

        @Override
        protected Collection<DisassemblyInject> getDisassemblyInjections(TracePlatform platform) {
            return INJECTS;
        }
    }

    static enum Mode {
        X64,
        X86,
        UNK;


        static Mode computeFor(PluginTool tool, Trace trace, Address address, long snap) {
            DebuggerListingService listing = (DebuggerListingService)tool.getService(DebuggerListingService.class);
            AutoReadMemorySpec readSpec = listing.getAutoReadMemorySpec();
            DebuggerTargetService targetService = (DebuggerTargetService)tool.getService(DebuggerTargetService.class);
            Target target = targetService == null ? null : targetService.getTarget(trace);
            DebuggerCoordinates coords = DebuggerCoordinates.NOWHERE.platform(trace.getPlatformManager().getHostPlatform()).snap(snap).target(target);
            Collection modules = trace.getModuleManager().getModulesAt(snap, address);
            Msg.debug(Mode.class, (Object)("Computing mode from modules: " + modules.stream().map(m -> m.getName(snap)).collect(Collectors.joining(","))));
            Set modes = modules.stream().map(m -> Mode.modeForModule(tool, readSpec, coords, m)).filter(m -> m != UNK).collect(Collectors.toSet());
            Msg.debug(Mode.class, (Object)("  Got mode(s): " + String.valueOf(modes)));
            if (modes.size() != 1) {
                return UNK;
            }
            return (Mode)((Object)modes.iterator().next());
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        static Mode modeForModule(PluginTool tool, AutoReadMemorySpec readSpec, DebuggerCoordinates coords, TraceModule module) {
            AddressSet set = new AddressSet();
            Trace trace = coords.getTrace();
            long snap = coords.getSnap();
            Address base = module.getBase(snap);
            set.add(base, base);
            try {
                readSpec.readMemory(tool, coords, (AddressSetView)set).get(1L, TimeUnit.SECONDS);
                trace.flushEvents();
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                DebuggerConsoleService console = (DebuggerConsoleService)tool.getService(DebuggerConsoleService.class);
                String message = "Could not read PE header of %s to determine x86 vs x64 mode".formatted(module.getName(snap));
                if (console != null) {
                    console.log(DebuggerResources.ICON_LOG_ERROR, message, (Throwable)e);
                }
                Msg.error(Mode.class, (Object)message, (Throwable)e);
            }
            MemBuffer bufferAt = trace.getMemoryManager().getBufferAt(snap, module.getBase(snap));
            try (MemBufferByteProvider bp = new MemBufferByteProvider(bufferAt);){
                PortableExecutable pe = new PortableExecutable((ByteProvider)bp, PortableExecutable.SectionLayout.MEMORY, false, false);
                NTHeader ntHeader = pe.getNTHeader();
                if (ntHeader == null) {
                    Mode mode = UNK;
                    return mode;
                }
                OptionalHeader optionalHeader = ntHeader.getOptionalHeader();
                if (optionalHeader == null) {
                    Mode mode = UNK;
                    return mode;
                }
                Mode mode = optionalHeader.is64bit() ? X64 : X86;
                return mode;
            }
            catch (IOException e) {
                Msg.warn(Mode.class, (Object)("Could not parse PE from trace: " + String.valueOf(e)));
                return UNK;
            }
        }
    }
}

