/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.platform.dbgeng;

import ghidra.app.plugin.core.debug.disassemble.DisassemblyInject;
import ghidra.app.plugin.core.debug.disassemble.DisassemblyInjectInfo;
import ghidra.app.plugin.core.debug.disassemble.TraceDisassembleCommand;
import ghidra.app.plugin.core.debug.platform.dbgeng.DbgengDebuggerPlatformOpinion;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.listing.DefaultProgramContext;
import ghidra.program.util.ProgramContextImpl;
import ghidra.trace.model.Trace;
import ghidra.trace.model.guest.TracePlatform;
import ghidra.trace.model.thread.TraceThread;
import java.math.BigInteger;

@DisassemblyInjectInfo(platforms={@DisassemblyInjectInfo.PlatformInfo(langID="x86:LE:64:default", compilerID="windows"), @DisassemblyInjectInfo.PlatformInfo(langID="x86:LE:64:default", compilerID="clangwindows")})
public class DbgengX64DisassemblyInject
implements DisassemblyInject {
    @Override
    public void pre(PluginTool tool, TraceDisassembleCommand command, TracePlatform platform, long snap, TraceThread thread, AddressSetView startSet, AddressSetView restricted) {
        AddressRange first = startSet.getFirstRange();
        if (first == null) {
            return;
        }
        Trace trace = platform.getTrace();
        DbgengDebuggerPlatformOpinion.Mode mode = DbgengDebuggerPlatformOpinion.Mode.computeFor(tool, trace, first.getMinAddress(), snap);
        if (mode == DbgengDebuggerPlatformOpinion.Mode.UNK) {
            return;
        }
        Language language = platform.getLanguage();
        Register longModeReg = language.getRegister("longMode");
        Register addrsizeReg = language.getRegister("addrsize");
        Register opsizeReg = language.getRegister("opsize");
        ProgramContextImpl context = new ProgramContextImpl(language);
        language.applyContextSettings((DefaultProgramContext)context);
        RegisterValue ctxVal = context.getDisassemblyContext(first.getMinAddress());
        command.setInitialContext(switch (mode) {
            case DbgengDebuggerPlatformOpinion.Mode.X64 -> ctxVal.assign(longModeReg, BigInteger.ONE).assign(addrsizeReg, BigInteger.TWO).assign(opsizeReg, BigInteger.ONE);
            case DbgengDebuggerPlatformOpinion.Mode.X86 -> ctxVal.assign(longModeReg, BigInteger.ZERO).assign(addrsizeReg, BigInteger.ONE).assign(opsizeReg, BigInteger.ONE);
            default -> throw new AssertionError();
        });
    }
}

