/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.elf.extend;

import ghidra.app.util.bin.format.elf.ElfHeader;
import ghidra.app.util.bin.format.elf.ElfLoadHelper;
import ghidra.app.util.bin.format.elf.extend.ElfExtension;
import ghidra.program.model.lang.Language;

public class RISCV_ElfExtension
extends ElfExtension {
    public static final String RISCV_PROC = "RISCV";
    public static final String RISCV_SUFFIX = "_RISCV";

    public boolean canHandle(ElfHeader elf) {
        return elf.e_machine() == 243;
    }

    public boolean canHandle(ElfLoadHelper elfLoadHelper) {
        if (!this.canHandle(elfLoadHelper.getElfHeader())) {
            return false;
        }
        Language language = elfLoadHelper.getProgram().getLanguage();
        int size = language.getLanguageDescription().getSize();
        return (32 == size || 64 == size) && language.getProcessor().toString().equals(RISCV_PROC);
    }

    public String getDataTypeSuffix() {
        return RISCV_SUFFIX;
    }
}

