/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.assembler.sleigh.sem;

import ghidra.app.plugin.assembler.sleigh.expr.RecursiveDescentSolver;
import ghidra.app.plugin.assembler.sleigh.grammars.AssemblyGrammar;
import ghidra.app.plugin.assembler.sleigh.grammars.AssemblyProduction;
import ghidra.app.plugin.assembler.sleigh.sem.AbstractAssemblyResolutionFactory;
import ghidra.app.plugin.assembler.sleigh.sem.AbstractAssemblyStateGenerator;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyConstructStateGenerator;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyConstructorSemantic;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyContextGraph;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyDefaultContext;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyGeneratedPrototype;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyHiddenConstructStateGenerator;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyNopStateGenerator;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyOperandStateGenerator;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyPatternBlock;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyResolution;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyResolutionResults;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyResolvedBackfill;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyResolvedError;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyResolvedPatterns;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyStringStateGenerator;
import ghidra.app.plugin.assembler.sleigh.symbol.AssemblyNonTerminal;
import ghidra.app.plugin.assembler.sleigh.tree.AssemblyParseBranch;
import ghidra.app.plugin.assembler.sleigh.tree.AssemblyParseHiddenNode;
import ghidra.app.plugin.assembler.sleigh.tree.AssemblyParseNumericToken;
import ghidra.app.plugin.assembler.sleigh.tree.AssemblyParseToken;
import ghidra.app.plugin.assembler.sleigh.tree.AssemblyParseTreeNode;
import ghidra.app.plugin.assembler.sleigh.util.DbgTimer;
import ghidra.app.plugin.processors.sleigh.Constructor;
import ghidra.app.plugin.processors.sleigh.SleighInstructionPrototype;
import ghidra.app.plugin.processors.sleigh.SleighLanguage;
import ghidra.app.plugin.processors.sleigh.symbol.OperandSymbol;
import ghidra.app.plugin.processors.sleigh.symbol.SubtableSymbol;
import ghidra.app.plugin.processors.sleigh.symbol.TripleSymbol;
import ghidra.program.model.address.Address;
import ghidra.program.model.lang.InsufficientBytesException;
import ghidra.program.model.lang.UnknownInstructionException;
import ghidra.program.model.mem.ByteMemBufferImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class AbstractAssemblyTreeResolver<RP extends AssemblyResolvedPatterns> {
    protected static final RecursiveDescentSolver SOLVER = RecursiveDescentSolver.getSolver();
    protected static final DbgTimer DBG = DbgTimer.INACTIVE;
    public static final String INST_START = "inst_start";
    public static final String INST_NEXT = "inst_next";
    public static final String INST_NEXT2 = "inst_next2";
    protected final AbstractAssemblyResolutionFactory<RP, ?> factory;
    protected final SleighLanguage lang;
    protected final Address at;
    protected final Map<String, Long> vals = new HashMap<String, Long>();
    protected final AssemblyParseBranch tree;
    protected final AssemblyGrammar grammar;
    protected final AssemblyPatternBlock context;
    protected final AssemblyContextGraph ctxGraph;

    public AbstractAssemblyTreeResolver(AbstractAssemblyResolutionFactory<RP, ?> factory, SleighLanguage lang, Address at, AssemblyParseBranch tree, AssemblyPatternBlock context, AssemblyContextGraph ctxGraph) {
        this.factory = factory;
        this.lang = lang;
        this.at = at;
        this.vals.put(INST_START, at.getAddressableWordOffset());
        this.tree = tree;
        this.grammar = tree.getGrammar();
        this.context = context.fillMask();
        this.ctxGraph = ctxGraph;
    }

    public AbstractAssemblyResolutionFactory<RP, ?> getFactory() {
        return this.factory;
    }

    public AssemblyResolutionResults resolve() {
        Object empty = this.factory.nop("Empty");
        AssemblyConstructStateGenerator rootGen = new AssemblyConstructStateGenerator((AbstractAssemblyTreeResolver<?>)this, this.tree, (AssemblyResolvedPatterns)empty);
        ArrayList errors = new ArrayList();
        Stream<AssemblyGeneratedPrototype> protStream = rootGen.generate(new AbstractAssemblyStateGenerator.GeneratorContext(List.of(), 0));
        if (DBG == DbgTimer.ACTIVE) {
            try (DbgTimer.DbgCtx dc = DBG.start("Prototypes:");){
                protStream = protStream.map(prot -> {
                    DBG.println(prot);
                    return prot;
                }).collect(Collectors.toList()).stream();
            }
        }
        Stream<AssemblyResolutionResults> patStream = protStream.map(p -> p.state).distinct().flatMap(s -> s.resolve((AssemblyResolvedPatterns)empty, errors));
        AssemblyResolutionResults results = patStream.collect(Collectors.toCollection(this.factory::newAssemblyResolutionResults));
        results = this.resolveRootRecursion(results);
        results = this.selectContext(results);
        results = this.resolvePendingBackfills(results);
        results = this.filterForbidden(results);
        results = this.filterByDisassembly(results);
        for (AssemblyResolvedError err : errors) {
            results.add(err);
        }
        return results;
    }

    protected AssemblyProduction getRootRecursion() {
        assert (this.tree.getParent() == null);
        AssemblyProduction rootProd = this.tree.getProduction();
        Object start = rootProd.getLHS();
        AssemblyProduction rec = this.grammar.getPureRecursion((AssemblyNonTerminal)start);
        return rec;
    }

    public AssemblyResolutionResults resolveRootRecursion(AssemblyResolutionResults temp) {
        AssemblyProduction rootRec = this.getRootRecursion();
        if (rootRec == null) {
            return temp;
        }
        try (DbgTimer.DbgCtx dc = DBG.start("Resolving root recursion:");){
            AssemblyResolutionResults result = this.factory.newAssemblyResolutionResults();
            Object object = temp.iterator();
            while (object.hasNext()) {
                AssemblyResolution ar = (AssemblyResolution)object.next();
                if (ar.isError()) {
                    result.add(ar);
                    continue;
                }
                AssemblyResolvedPatterns rp = (AssemblyResolvedPatterns)ar;
                AssemblyPatternBlock dst = rp.getContext();
                AssemblyPatternBlock src = this.context;
                String table = "instruction";
                DBG.println("Finding paths from " + String.valueOf(src) + " to " + ar.lineToString());
                Collection<Deque<AssemblyConstructorSemantic>> paths = this.ctxGraph.computeOptimalApplications(src, table, dst, table);
                DBG.println("Found " + paths.size());
                for (Deque<AssemblyConstructorSemantic> path : paths) {
                    DBG.println("  " + String.valueOf(path));
                    result.absorb(this.applyRecursionPath(path, this.tree, rootRec, ar));
                }
            }
            object = result;
            return object;
        }
    }

    protected AssemblyResolutionResults resolvePendingBackfills(AssemblyResolutionResults temp) {
        return temp.apply(this.factory, rp -> {
            if (!rp.hasBackfills()) {
                return rp;
            }
            this.vals.put(INST_NEXT, this.at.add(rp.getInstructionLength()).getAddressableWordOffset());
            this.vals.put(INST_NEXT2, this.at.add(rp.getInstructionLength()).getAddressableWordOffset());
            DBG.println("Backfilling: " + String.valueOf(rp));
            AssemblyResolution ar = rp.backfill(SOLVER, this.vals);
            DBG.println("Backfilled final: " + String.valueOf(ar));
            return ar;
        }).apply(this.factory, rp -> {
            if (rp.hasBackfills()) {
                return ((AbstractAssemblyResolutionFactory.AssemblyResolvedErrorBuilder)((AbstractAssemblyResolutionFactory.AssemblyResolvedErrorBuilder)this.factory.newErrorBuilder().error("Solution is incomplete").description("failed backfill")).children(List.of(rp))).build();
            }
            return rp;
        });
    }

    protected AssemblyResolutionResults selectContext(AssemblyResolutionResults temp) {
        RP ctx = this.factory.contextOnly(this.context, "Selecting context");
        return temp.apply(this.factory, rp -> {
            AssemblyResolvedPatterns check = rp.combine((AssemblyResolvedPatterns)ctx);
            if (null == check) {
                return ((AbstractAssemblyResolutionFactory.AssemblyResolvedErrorBuilder)((AbstractAssemblyResolutionFactory.AssemblyResolvedErrorBuilder)this.factory.newErrorBuilder().error("Incompatible context").description("resolving")).children(List.of(rp))).build();
            }
            return check;
        });
    }

    protected AssemblyResolutionResults filterForbidden(AssemblyResolutionResults temp) {
        return temp.apply(this.factory, rp -> rp.checkNotForbidden());
    }

    protected AssemblyResolutionResults filterByDisassembly(AssemblyResolutionResults temp) {
        AssemblyDefaultContext asmCtx = new AssemblyDefaultContext(this.lang);
        asmCtx.setContextRegister(this.context);
        return temp.apply(this.factory, rp -> {
            ByteMemBufferImpl buf = new ByteMemBufferImpl(this.at, rp.getInstruction().getVals(), this.lang.isBigEndian());
            try {
                SleighInstructionPrototype ip = (SleighInstructionPrototype)this.lang.parse(buf, asmCtx, false);
                if (!rp.equivalentConstructState(ip.getRootState())) {
                    return this.factory.error("Disassembly prototype mismatch", (AssemblyResolution)rp);
                }
                return rp;
            }
            catch (InsufficientBytesException | UnknownInstructionException e) {
                return this.factory.error("Disassembly failed: " + e.getMessage(), (AssemblyResolution)rp);
            }
        });
    }

    protected AbstractAssemblyStateGenerator<?> getStateGenerator(OperandSymbol opSym, AssemblyParseTreeNode node, AssemblyResolvedPatterns fromLeft) {
        if (node instanceof AssemblyParseHiddenNode) {
            return this.getHiddenStateGenerator(opSym, fromLeft);
        }
        if (node instanceof AssemblyParseNumericToken) {
            AssemblyParseNumericToken token = (AssemblyParseNumericToken)node;
            return new AssemblyOperandStateGenerator(this, token, opSym, fromLeft);
        }
        if (node instanceof AssemblyParseBranch) {
            AssemblyParseBranch branch = (AssemblyParseBranch)node;
            return new AssemblyConstructStateGenerator(this, branch, fromLeft);
        }
        if (node instanceof AssemblyParseToken) {
            AssemblyParseToken token = (AssemblyParseToken)node;
            if (node.getSym().takesOperandIndex()) {
                return new AssemblyStringStateGenerator(this, token, opSym, fromLeft);
            }
        }
        throw new AssertionError();
    }

    protected AbstractAssemblyStateGenerator<?> getHiddenStateGenerator(OperandSymbol opSym, AssemblyResolvedPatterns fromLeft) {
        TripleSymbol defSym = opSym.getDefiningSymbol();
        if (defSym instanceof SubtableSymbol) {
            SubtableSymbol subtable = (SubtableSymbol)defSym;
            return new AssemblyHiddenConstructStateGenerator(this, subtable, fromLeft);
        }
        return new AssemblyNopStateGenerator(this, opSym, fromLeft);
    }

    protected AssemblyResolutionResults resolvePatterns(AssemblyConstructorSemantic sem, int shift, AssemblyResolutionResults fromChildren) {
        AssemblyResolutionResults results = fromChildren;
        results = this.applyMutations(sem, results);
        results = this.applyPatterns(sem, shift, results);
        results = this.tryResolveBackfills(results);
        return results;
    }

    protected AssemblyResolutionResults parent(String description, AssemblyResolutionResults temp, int opCount) {
        return temp.stream().map(r -> r.parent(description, opCount)).collect(Collectors.toCollection(this.factory::newAssemblyResolutionResults));
    }

    protected AssemblyResolutionResults applyMutations(AssemblyConstructorSemantic sem, AssemblyResolutionResults temp) {
        DBG.println("Applying context mutations:");
        return temp.apply(this.factory, rp -> {
            DBG.println("Current: " + rp.lineToString());
            AssemblyResolution backctx = sem.solveContextChanges((AssemblyResolvedPatterns)rp, this.vals);
            DBG.println("Mutated: " + backctx.lineToString());
            return backctx;
        }).apply(this.factory, rp -> rp.solveContextChangesForForbids(sem, this.vals));
    }

    protected AssemblyResolutionResults applyPatterns(AssemblyConstructorSemantic sem, int shift, AssemblyResolutionResults temp) {
        DBG.println("Applying patterns:");
        final Collection patterns = sem.getPatterns().stream().map(p -> p.shift(shift)).collect(Collectors.toList());
        return temp.apply(this.factory, new AssemblyResolutionResults.Applicator(){

            public Iterable<AssemblyResolution> getPatterns(AssemblyResolvedPatterns cur) {
                return patterns;
            }

            @Override
            public AssemblyResolvedPatterns setRight(AssemblyResolvedPatterns res, AssemblyResolvedPatterns cur) {
                return res;
            }

            @Override
            public String describeError(AssemblyResolvedPatterns rp, AssemblyResolution pat) {
                return "The patterns conflict " + pat.lineToString();
            }

            @Override
            public AssemblyResolvedPatterns combineBackfill(AssemblyResolvedPatterns cur, AssemblyResolvedBackfill bf) {
                throw new AssertionError();
            }

            @Override
            public AssemblyResolution finish(AssemblyResolvedPatterns resolved) {
                return resolved.checkNotForbidden();
            }
        });
    }

    protected AssemblyResolutionResults applyRecursionPath(Deque<AssemblyConstructorSemantic> path, AssemblyParseBranch branch, AssemblyProduction rec, AssemblyResolution child) {
        AssemblyResolutionResults results = this.factory.newAssemblyResolutionResults();
        results.add(child);
        while (!path.isEmpty()) {
            AssemblyConstructorSemantic sem = path.pollLast();
            int opIdx = sem.getOperandIndex(0);
            Constructor cons = sem.getConstructor();
            OperandSymbol opSym = cons.getOperand(opIdx);
            if (-1 != opSym.getOffsetBase()) {
                throw new AssertionError((Object)"TODO");
            }
            int offset = opSym.getRelativeOffset();
            results = this.parent("Resolving recursive constructor: " + cons.getSourceFile() + ":" + cons.getLineno(), results, 1);
            results = results.apply(this.factory, rp -> rp.shift(offset));
            results = this.resolvePatterns(sem, 0, results).apply(this.factory, rp -> rp.withConstructor(cons));
        }
        return results;
    }

    protected AssemblyResolutionResults tryResolveBackfills(AssemblyResolutionResults results) {
        AssemblyResolutionResults res = this.factory.newAssemblyResolutionResults();
        Iterator iterator = results.iterator();
        block0: while (iterator.hasNext()) {
            AssemblyResolvedPatterns rp;
            AssemblyResolution ar = (AssemblyResolution)iterator.next();
            if (ar.isError()) {
                res.add(ar);
                continue;
            }
            do {
                if (!(rp = (AssemblyResolvedPatterns)ar).hasBackfills()) {
                    res.add(ar);
                    continue block0;
                }
                ar = rp.backfill(SOLVER, this.vals);
                if (!ar.isError() && !ar.isBackfill()) continue;
                res.add(ar);
                continue block0;
            } while (!ar.equals(rp));
            res.add(ar);
        }
        return res;
    }

    public static int computeOffset(OperandSymbol opsym, Constructor cons) {
        int offset = opsym.getRelativeOffset();
        int baseidx = opsym.getOffsetBase();
        if (baseidx != -1) {
            OperandSymbol baseop = cons.getOperand(baseidx);
            offset += baseop.getMinimumLength();
            offset += AbstractAssemblyTreeResolver.computeOffset(baseop, cons);
        }
        return offset;
    }

    public AssemblyGrammar getGrammar() {
        return this.grammar;
    }
}

