/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcodeCPort.globalcontext;

public class ContextBitRange {
    private int word;
    private int startbit;
    private int endbit;
    private int shift;
    private int mask;

    public ContextBitRange(int sbit, int ebit) {
        this.word = sbit / 32;
        this.startbit = sbit - this.word * 32;
        this.endbit = ebit - this.word * 32;
        this.shift = 32 - this.endbit - 1;
        this.mask = -1 >>> this.startbit + this.shift;
    }

    public void setValue(int[] vec, int val) {
        int newval = vec[this.word];
        newval &= ~(this.mask << this.shift);
        vec[this.word] = newval |= (val & this.mask) << this.shift;
    }

    public int getValue(int[] vec) {
        return vec[this.word] >> this.shift & this.mask;
    }
}

