/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcodeCPort.semantics;

import generic.stl.IteratorSTL;
import generic.stl.Pair;
import generic.stl.VectorSTL;
import ghidra.pcode.utils.SlaFormat;
import ghidra.pcodeCPort.opcodes.OpCode;
import ghidra.pcodeCPort.semantics.ConstTpl;
import ghidra.pcodeCPort.semantics.HandleTpl;
import ghidra.pcodeCPort.semantics.OpTpl;
import ghidra.pcodeCPort.semantics.VarnodeTpl;
import ghidra.pcodeCPort.space.AddrSpace;
import ghidra.program.model.pcode.Encoder;
import ghidra.sleigh.grammar.Location;
import ghidra.sleigh.grammar.LocationUtil;
import java.io.IOException;
import java.util.ArrayList;

public class ConstructTpl {
    public final Location loc;
    protected int delayslot;
    protected int numlabels;
    protected VectorSTL<OpTpl> vec = new VectorSTL();
    protected HandleTpl result;

    public ConstructTpl(Location loc) {
        this.loc = loc;
        this.delayslot = 0;
        this.numlabels = 0;
        this.result = null;
    }

    public int delaySlot() {
        return this.delayslot;
    }

    public int numLabels() {
        return this.numlabels;
    }

    public void setNumLabels(int val) {
        this.numlabels = val;
    }

    public void setOpvec(VectorSTL<OpTpl> opvec) {
        this.vec = opvec;
    }

    public VectorSTL<OpTpl> getOpvec() {
        return this.vec;
    }

    public HandleTpl getResult() {
        return this.result;
    }

    public void setResult(HandleTpl t) {
        this.result = t;
    }

    public void dispose() {
        IteratorSTL oiter = this.vec.begin();
        while (!oiter.isEnd()) {
            ((OpTpl)oiter.get()).dispose();
            oiter.increment();
        }
        if (this.result != null) {
            // empty if block
        }
    }

    public boolean addOp(OpTpl ot) {
        if (ot.getOpcode() == OpCode.CPUI_INDIRECT) {
            if (this.delayslot != 0) {
                return false;
            }
            this.delayslot = (int)ot.getIn(0).getOffset().getReal();
        } else if (ot.getOpcode() == OpCode.CPUI_PTRADD) {
            ++this.numlabels;
        }
        this.vec.push_back((Object)ot);
        return true;
    }

    public boolean addOpList(VectorSTL<OpTpl> oplist) {
        for (int i = 0; i < oplist.size(); ++i) {
            if (this.addOp((OpTpl)oplist.get(i))) continue;
            return false;
        }
        return true;
    }

    public Pair<Integer, Location> fillinBuild(VectorSTL<Integer> check, AddrSpace const_space) {
        OpTpl op;
        ArrayList<Location> locations = new ArrayList<Location>();
        IteratorSTL iter = this.vec.begin();
        while (!iter.isEnd()) {
            op = (OpTpl)iter.get();
            locations.add(op.location);
            if (op.getOpcode() == OpCode.CPUI_MULTIEQUAL) {
                int index = (int)op.getIn(0).getOffset().getReal();
                if ((Integer)check.get(index) != 0) {
                    return new Pair((Object)((Integer)check.get(index)), (Object)op.location);
                }
                check.set(index, (Object)1);
            }
            iter.increment();
        }
        Location min = LocationUtil.minimum(locations);
        for (int i = 0; i < check.size(); ++i) {
            if ((Integer)check.get(i) != 0) continue;
            op = new OpTpl(min, OpCode.CPUI_MULTIEQUAL);
            VarnodeTpl indvn = new VarnodeTpl(min, new ConstTpl(const_space), new ConstTpl(ConstTpl.const_type.real, i), new ConstTpl(ConstTpl.const_type.real, 4L));
            op.addInput(indvn);
            this.vec.insert(this.vec.begin(), (Object)op);
        }
        return new Pair((Object)0, null);
    }

    public boolean buildOnly() {
        for (OpTpl op : this.vec) {
            if (op.getOpcode() == OpCode.CPUI_MULTIEQUAL) continue;
            return false;
        }
        return true;
    }

    public void changeHandleIndex(VectorSTL<Integer> handmap) {
        IteratorSTL iter = this.vec.begin();
        while (!iter.isEnd()) {
            OpTpl op = (OpTpl)iter.get();
            if (op.getOpcode() == OpCode.CPUI_MULTIEQUAL) {
                int index = (int)op.getIn(0).getOffset().getReal();
                index = (Integer)handmap.get(index);
                op.getIn(0).setOffset(index);
            } else {
                op.changeHandleIndex(handmap);
            }
            iter.increment();
        }
        if (this.result != null) {
            this.result.changeHandleIndex(handmap);
        }
    }

    public void setInput(VarnodeTpl vn, int index, int slot) {
        OpTpl op = (OpTpl)this.vec.get(index);
        VarnodeTpl oldvn = op.getIn(slot);
        op.setInput(vn, slot);
        if (oldvn != null) {
            oldvn.dispose();
        }
    }

    public void setOutput(VarnodeTpl vn, int index) {
        OpTpl op = (OpTpl)this.vec.get(index);
        VarnodeTpl oldvn = op.getOut();
        op.setOutput(vn);
        if (oldvn != null) {
            oldvn.dispose();
        }
    }

    public void deleteOps(VectorSTL<Integer> indices) {
        for (int i = 0; i < indices.size(); ++i) {
            this.vec.get(((Integer)indices.get(i)).intValue());
            this.vec.set(((Integer)indices.get(i)).intValue(), null);
        }
        int poscur = 0;
        for (int i = 0; i < this.vec.size(); ++i) {
            OpTpl op = (OpTpl)this.vec.get(i);
            if (op == null) continue;
            this.vec.set(poscur, (Object)op);
            ++poscur;
        }
        while (this.vec.size() > poscur) {
            this.vec.pop_back();
        }
    }

    public void encode(Encoder encoder, int sectionid) throws IOException {
        encoder.openElement(SlaFormat.ELEM_CONSTRUCT_TPL);
        if (sectionid >= 0) {
            encoder.writeSignedInteger(SlaFormat.ATTRIB_SECTION, sectionid);
        }
        if (this.delayslot != 0) {
            encoder.writeSignedInteger(SlaFormat.ATTRIB_DELAY, this.delayslot);
        }
        if (this.numlabels != 0) {
            encoder.writeSignedInteger(SlaFormat.ATTRIB_LABELS, this.numlabels);
        }
        if (this.result != null) {
            this.result.encode(encoder);
        } else {
            encoder.openElement(SlaFormat.ELEM_NULL);
            encoder.closeElement(SlaFormat.ELEM_NULL);
        }
        for (int i = 0; i < this.vec.size(); ++i) {
            ((OpTpl)this.vec.get(i)).encode(encoder);
        }
        encoder.closeElement(SlaFormat.ELEM_CONSTRUCT_TPL);
    }
}

