/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcodeCPort.slghpattern;

import generic.stl.IteratorSTL;
import generic.stl.VectorSTL;
import ghidra.pcode.utils.SlaFormat;
import ghidra.pcodeCPort.utils.Utils;
import ghidra.program.model.pcode.Encoder;
import java.io.IOException;

public class PatternBlock {
    int offset;
    int nonzerosize;
    VectorSTL<Integer> maskvec = new VectorSTL();
    VectorSTL<Integer> valvec = new VectorSTL();

    public void shift(int sa) {
        this.offset += sa;
        this.normalize();
    }

    public int getLength() {
        return this.offset + this.nonzerosize;
    }

    public boolean alwaysTrue() {
        return this.nonzerosize == 0;
    }

    public boolean alwaysFalse() {
        return this.nonzerosize == -1;
    }

    public void dispose() {
    }

    private void normalize() {
        if (this.nonzerosize <= 0) {
            this.offset = 0;
            this.maskvec.clear();
            this.valvec.clear();
            return;
        }
        IteratorSTL iter1 = this.maskvec.begin();
        IteratorSTL iter2 = this.valvec.begin();
        while (!iter1.isEnd() && (Integer)iter1.get() == 0) {
            iter1.increment();
            iter2.increment();
            this.offset += 4;
        }
        this.maskvec.erase(this.maskvec.begin(), iter1);
        this.valvec.erase(this.valvec.begin(), iter2);
        if (!this.maskvec.empty()) {
            int tmp;
            int suboff = 0;
            for (tmp = ((Integer)this.maskvec.get(0)).intValue(); tmp != 0; tmp >>>= 8) {
                ++suboff;
            }
            if ((suboff = 4 - suboff) != 0) {
                int i;
                this.offset += suboff;
                for (i = 0; i < this.maskvec.size() - 1; ++i) {
                    tmp = (Integer)this.maskvec.get(i) << suboff * 8;
                    this.maskvec.set(i, (Object)(tmp |= (Integer)this.maskvec.get(i + 1) >>> (4 - suboff) * 8));
                }
                this.maskvec.setBack((Object)((Integer)this.maskvec.back() << suboff * 8));
                for (i = 0; i < this.valvec.size() - 1; ++i) {
                    tmp = (Integer)this.valvec.get(i) << suboff * 8;
                    this.valvec.set(i, (Object)(tmp |= (Integer)this.valvec.get(i + 1) >>> (4 - suboff) * 8));
                }
                this.valvec.setBack((Object)((Integer)this.valvec.back() << suboff * 8));
            }
            iter1 = this.maskvec.end();
            iter2 = this.valvec.end();
            while (!iter1.isBegin()) {
                iter1.decrement();
                iter2.decrement();
                if ((Integer)iter1.get() == 0) continue;
            }
            if (!iter1.isEnd()) {
                iter1.increment();
                iter2.increment();
            }
            this.maskvec.erase(iter1, this.maskvec.end());
            this.valvec.erase(iter2, this.valvec.end());
        }
        if (this.maskvec.empty()) {
            this.offset = 0;
            this.nonzerosize = 0;
            return;
        }
        this.nonzerosize = this.maskvec.size() * 4;
        int tmp = (Integer)this.maskvec.back();
        while ((tmp & 0xFF) == 0) {
            --this.nonzerosize;
            tmp >>>= 8;
        }
    }

    public PatternBlock(int off, int msk, int val) {
        this.offset = off;
        this.maskvec.push_back((Object)msk);
        this.valvec.push_back((Object)val);
        this.nonzerosize = 4;
        this.normalize();
    }

    public PatternBlock(boolean tf) {
        this.offset = 0;
        this.nonzerosize = tf ? 0 : -1;
    }

    public PatternBlock(PatternBlock a, PatternBlock b) {
        PatternBlock res = a.intersect(b);
        this.offset = res.offset;
        this.nonzerosize = res.nonzerosize;
        this.maskvec = res.maskvec.copy();
        this.valvec = res.valvec.copy();
        res.dispose();
    }

    public PatternBlock(VectorSTL<PatternBlock> list) {
        if (list.empty()) {
            this.offset = 0;
            this.nonzerosize = 0;
            return;
        }
        PatternBlock res = (PatternBlock)list.get(0);
        for (int i = 1; i < list.size(); ++i) {
            PatternBlock next = res.intersect((PatternBlock)list.get(i));
            res.dispose();
            res = next;
        }
        this.offset = res.offset;
        this.nonzerosize = res.nonzerosize;
        this.maskvec = res.maskvec.copy();
        this.valvec = res.valvec.copy();
        res.dispose();
    }

    public PatternBlock clone() {
        PatternBlock res = new PatternBlock(true);
        res.offset = this.offset;
        res.nonzerosize = this.nonzerosize;
        res.maskvec = this.maskvec.copy();
        res.valvec = this.valvec.copy();
        return res;
    }

    public PatternBlock commonSubPattern(PatternBlock b) {
        PatternBlock res = new PatternBlock(true);
        int maxlength = this.getLength() > b.getLength() ? this.getLength() : b.getLength();
        res.offset = 0;
        for (int offset1 = 0; offset1 < maxlength; offset1 += 4) {
            int mask1 = this.getMask(offset1 * 8, 32);
            int val1 = this.getValue(offset1 * 8, 32);
            int mask2 = b.getMask(offset1 * 8, 32);
            int val2 = b.getValue(offset1 * 8, 32);
            int resmask = mask1 & mask2 & ~(val1 ^ val2);
            int resval = val1 & val2 & resmask;
            res.maskvec.push_back((Object)resmask);
            res.valvec.push_back((Object)resval);
        }
        res.nonzerosize = maxlength;
        res.normalize();
        return res;
    }

    public PatternBlock intersect(PatternBlock b) {
        if (this.alwaysFalse() || b.alwaysFalse()) {
            return new PatternBlock(false);
        }
        PatternBlock res = new PatternBlock(true);
        int maxlength = this.getLength() > b.getLength() ? this.getLength() : b.getLength();
        res.offset = 0;
        for (int offset1 = 0; offset1 < maxlength; offset1 += 4) {
            int val2;
            int mask1 = this.getMask(offset1 * 8, 32);
            int val1 = this.getValue(offset1 * 8, 32);
            int mask2 = b.getMask(offset1 * 8, 32);
            int commonmask = mask1 & mask2;
            if ((commonmask & val1) != (commonmask & (val2 = b.getValue(offset1 * 8, 32)))) {
                res.nonzerosize = -1;
                res.normalize();
                return res;
            }
            int resmask = mask1 | mask2;
            int resval = mask1 & val1 | mask2 & val2;
            res.maskvec.push_back((Object)resmask);
            res.valvec.push_back((Object)resval);
        }
        res.nonzerosize = maxlength;
        res.normalize();
        return res;
    }

    public boolean specializes(PatternBlock op2) {
        int tmplength;
        int length = 8 * op2.getLength();
        for (int sbit = 0; sbit < length; sbit += tmplength) {
            tmplength = length - sbit;
            if (tmplength > 32) {
                tmplength = 32;
            }
            int mask1 = this.getMask(sbit, tmplength);
            int value1 = this.getValue(sbit, tmplength);
            int mask2 = op2.getMask(sbit, tmplength);
            int value2 = op2.getValue(sbit, tmplength);
            if ((mask1 & mask2) != mask2) {
                return false;
            }
            if ((value1 & mask2) == (value2 & mask2)) continue;
            return false;
        }
        return true;
    }

    public boolean identical(PatternBlock op2) {
        int length = 8 * op2.getLength();
        int tmplength = 8 * this.getLength();
        if (tmplength > length) {
            length = tmplength;
        }
        for (int sbit = 0; sbit < length; sbit += tmplength) {
            tmplength = length - sbit;
            if (tmplength > 32) {
                tmplength = 32;
            }
            int mask1 = this.getMask(sbit, tmplength);
            int value1 = this.getValue(sbit, tmplength);
            int mask2 = op2.getMask(sbit, tmplength);
            int value2 = op2.getValue(sbit, tmplength);
            if (mask1 != mask2) {
                return false;
            }
            if ((mask1 & value1) == (mask2 & value2)) continue;
            return false;
        }
        return true;
    }

    public int getMask(int startbit, int size) {
        int wordnum1 = Utils.unsignedDivide(startbit -= 8 * this.offset, 32);
        int shift = Utils.unsignedModulo(startbit, 32);
        int wordnum2 = Utils.unsignedDivide(startbit + size - 1, 32);
        int res = wordnum1 < 0 || wordnum1 >= this.maskvec.size() ? 0 : (Integer)this.maskvec.get(wordnum1);
        res <<= shift;
        if (wordnum1 != wordnum2) {
            int tmp = wordnum2 < 0 || wordnum2 >= this.maskvec.size() ? 0 : (Integer)this.maskvec.get(wordnum2);
            res |= tmp >>> 32 - shift;
        }
        return res >>>= 32 - size;
    }

    public int getValue(int startbit, int size) {
        int wordnum1 = Utils.unsignedDivide(startbit -= 8 * this.offset, 32);
        int shift = Utils.unsignedModulo(startbit, 32);
        int wordnum2 = Utils.unsignedDivide(startbit + size - 1, 32);
        int res = wordnum1 < 0 || wordnum1 >= this.valvec.size() ? 0 : (Integer)this.valvec.get(wordnum1);
        res <<= shift;
        if (wordnum1 != wordnum2) {
            int tmp = wordnum2 < 0 || wordnum2 >= this.valvec.size() ? 0 : (Integer)this.valvec.get(wordnum2);
            res |= tmp >>> 32 - shift;
        }
        return res >>>= 32 - size;
    }

    public void encode(Encoder encoder) throws IOException {
        encoder.openElement(SlaFormat.ELEM_PAT_BLOCK);
        encoder.writeSignedInteger(SlaFormat.ATTRIB_OFF, this.offset);
        encoder.writeSignedInteger(SlaFormat.ATTRIB_NONZERO, this.nonzerosize);
        for (int i = 0; i < this.maskvec.size(); ++i) {
            encoder.openElement(SlaFormat.ELEM_MASK_WORD);
            encoder.writeUnsignedInteger(SlaFormat.ATTRIB_MASK, Utils.unsignedInt((Integer)this.maskvec.get(i)));
            encoder.writeUnsignedInteger(SlaFormat.ATTRIB_VAL, Utils.unsignedInt((Integer)this.valvec.get(i)));
            encoder.closeElement(SlaFormat.ELEM_MASK_WORD);
        }
        encoder.closeElement(SlaFormat.ELEM_PAT_BLOCK);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.offset; ++i) {
            sb.append("........ ");
        }
        int pos = -1;
        for (int i = 0; i < this.maskvec.size(); ++i) {
            int m = (Integer)this.maskvec.get(i);
            int v = (Integer)this.valvec.get(i);
            for (int j = 0; j < 32; ++j) {
                if (j % 8 == 0) {
                    if (++pos >= this.nonzerosize) {
                        return sb.toString();
                    }
                    if (i != 0 || j != 0) {
                        sb.append(' ');
                    }
                }
                if (m < 0) {
                    if (v < 0) {
                        sb.append('1');
                    } else {
                        sb.append('0');
                    }
                } else {
                    sb.append('.');
                }
                m <<= 1;
                v <<= 1;
            }
        }
        return sb.toString();
    }
}

