/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.code;

import db.DBHandle;
import db.DBRecord;
import db.RecordIterator;
import db.Table;
import ghidra.program.database.code.DataDBAdapter;
import ghidra.program.database.map.AddressKeyIterator;
import ghidra.program.database.map.AddressKeyRecordIterator;
import ghidra.program.database.map.AddressMap;
import ghidra.program.database.map.AddressRecordDeleter;
import ghidra.program.database.util.DatabaseTableUtils;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

class DataDBAdapterV0
extends DataDBAdapter {
    private Table dataTable;
    private AddressMap addrMap;

    public DataDBAdapterV0(DBHandle handle, AddressMap addrMap, boolean create) throws IOException, VersionException {
        this.addrMap = addrMap;
        if (create) {
            this.dataTable = handle.createTable("Data", DATA_SCHEMA);
        } else {
            this.dataTable = handle.getTable("Data");
            if (this.dataTable == null) {
                throw new VersionException("Missing Table: Data");
            }
            if (this.dataTable.getSchema().getVersion() != 0) {
                throw new VersionException(2, false);
            }
        }
    }

    @Override
    DBRecord getRecordAtOrAfter(Address addr) throws IOException {
        AddressKeyRecordIterator it = new AddressKeyRecordIterator(this.dataTable, this.addrMap, addr, true);
        return it.next();
    }

    @Override
    DBRecord getRecordAtOrBefore(Address addr) throws IOException {
        AddressKeyRecordIterator it = new AddressKeyRecordIterator(this.dataTable, this.addrMap, addr, false);
        return it.previous();
    }

    @Override
    DBRecord getRecordAfter(Address addr) throws IOException {
        AddressKeyRecordIterator it = new AddressKeyRecordIterator(this.dataTable, this.addrMap, addr, false);
        return it.next();
    }

    @Override
    DBRecord getRecord(Address addr) throws IOException {
        return this.dataTable.getRecord(this.addrMap.getKey(addr, false));
    }

    @Override
    DBRecord getRecord(long key) throws IOException {
        return this.dataTable.getRecord(key);
    }

    @Override
    DBRecord getRecordBefore(Address addr) throws IOException {
        AddressKeyRecordIterator it = new AddressKeyRecordIterator(this.dataTable, this.addrMap, addr, true);
        return it.previous();
    }

    @Override
    RecordIterator getRecords(Address addr, boolean forward) throws IOException {
        return new AddressKeyRecordIterator(this.dataTable, this.addrMap, addr, forward);
    }

    @Override
    RecordIterator getRecords(Address start, Address end, boolean atStart) throws IOException {
        if (atStart) {
            return new AddressKeyRecordIterator(this.dataTable, this.addrMap, start, end, start, true);
        }
        return new AddressKeyRecordIterator(this.dataTable, this.addrMap, start, end, end, false);
    }

    @Override
    RecordIterator getRecords(AddressSetView set, boolean forward) throws IOException {
        return new AddressKeyRecordIterator(this.dataTable, this.addrMap, set, forward ? set.getMinAddress() : set.getMaxAddress(), forward);
    }

    @Override
    void deleteRecord(long key) throws IOException {
        this.dataTable.deleteRecord(key);
    }

    @Override
    DBRecord createData(Address newAddr, long dataTypeID) throws IOException {
        long key = this.addrMap.getKey(newAddr, true);
        DBRecord record = DATA_SCHEMA.createRecord(key);
        record.setLongValue(0, dataTypeID);
        this.dataTable.putRecord(record);
        return record;
    }

    @Override
    boolean deleteRecords(Address start, Address end) throws IOException {
        return AddressRecordDeleter.deleteRecords(this.dataTable, this.addrMap, start, end);
    }

    @Override
    int getRecordCount() throws IOException {
        return this.dataTable.getRecordCount();
    }

    @Override
    AddressKeyIterator getKeys(Address start, Address end, boolean atStart) throws IOException {
        if (atStart) {
            return new AddressKeyIterator(this.dataTable, this.addrMap, start, end, start, true);
        }
        return new AddressKeyIterator(this.dataTable, this.addrMap, start, end, end, false);
    }

    @Override
    AddressKeyIterator getKeys(AddressSetView set, boolean forward) throws IOException {
        if (forward) {
            return new AddressKeyIterator(this.dataTable, this.addrMap, set, set.getMinAddress(), true);
        }
        return new AddressKeyIterator(this.dataTable, this.addrMap, set, set.getMaxAddress(), false);
    }

    @Override
    void putRecord(DBRecord record) throws IOException {
        this.dataTable.putRecord(record);
    }

    @Override
    RecordIterator getRecords() throws IOException {
        return new AddressKeyRecordIterator(this.dataTable, this.addrMap);
    }

    @Override
    void moveAddressRange(Address fromAddr, Address toAddr, long length, TaskMonitor monitor) throws CancelledException, IOException {
        DatabaseTableUtils.updateAddressKey(this.dataTable, this.addrMap, fromAddr, toAddr, length, monitor);
    }
}

