/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.data;

import ghidra.docking.settings.Settings;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.address.SegmentedAddressSpace;
import ghidra.program.model.data.AddressSpaceSettingsDefinition;
import ghidra.program.model.data.ComponentOffsetSettingsDefinition;
import ghidra.program.model.data.OffsetMaskSettingsDefinition;
import ghidra.program.model.data.OffsetShiftSettingsDefinition;
import ghidra.program.model.data.PointerType;
import ghidra.program.model.data.PointerTypeSettingsDefinition;
import ghidra.program.model.data.TypeDef;

public class PointerTypedefInspector {
    private PointerTypedefInspector() {
    }

    public static long getPointerComponentOffset(TypeDef pointerTypeDef) {
        return pointerTypeDef.isPointer() ? ComponentOffsetSettingsDefinition.DEF.getValue(pointerTypeDef.getDefaultSettings()) : 0L;
    }

    public static AddressSpace getPointerAddressSpace(TypeDef pointerTypeDef, AddressFactory addrFactory) {
        if (!pointerTypeDef.isPointer()) {
            return null;
        }
        Settings settings = pointerTypeDef.getDefaultSettings();
        String spaceName = AddressSpaceSettingsDefinition.DEF.getValue(settings);
        if (spaceName == null) {
            return null;
        }
        AddressSpace addressSpace = addrFactory.getAddressSpace(spaceName);
        if (addressSpace instanceof SegmentedAddressSpace) {
            return addressSpace;
        }
        PointerType choice = PointerTypeSettingsDefinition.DEF.getType(settings);
        return choice == PointerType.DEFAULT ? addressSpace : null;
    }

    public static boolean hasPointerBitShift(TypeDef pointerTypeDef) {
        return pointerTypeDef.isPointer() ? OffsetShiftSettingsDefinition.DEF.hasValue(pointerTypeDef.getDefaultSettings()) : false;
    }

    public static long getPointerBitShift(TypeDef pointerTypeDef) {
        return pointerTypeDef.isPointer() ? OffsetShiftSettingsDefinition.DEF.getValue(pointerTypeDef.getDefaultSettings()) : 0L;
    }

    public static boolean hasPointerBitMask(TypeDef pointerTypeDef) {
        return pointerTypeDef.isPointer() ? OffsetMaskSettingsDefinition.DEF.hasValue(pointerTypeDef.getDefaultSettings()) : false;
    }

    public static long getPointerBitMask(TypeDef pointerTypeDef) {
        return pointerTypeDef.isPointer() ? OffsetMaskSettingsDefinition.DEF.getValue(pointerTypeDef.getDefaultSettings()) : 0L;
    }

    public static PointerType getPointerType(TypeDef pointerTypeDef) {
        return pointerTypeDef.isPointer() ? PointerTypeSettingsDefinition.DEF.getType(pointerTypeDef.getDefaultSettings()) : null;
    }
}

