/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.data;

import db.DBHandle;
import db.DBRecord;
import db.Schema;
import ghidra.framework.data.OpenMode;
import ghidra.program.database.data.SourceArchiveAdapterNoTable;
import ghidra.program.database.data.SourceArchiveAdapterV0;
import ghidra.program.model.data.SourceArchive;
import ghidra.util.UniversalID;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;

abstract class SourceArchiveAdapter {
    static final String SOURCE_ARCHIVE_TABLE_NAME = "Data Type Archive IDs";
    static final Schema SCHEMA = SourceArchiveAdapterV0.V0_SCHEMA;
    static final int ARCHIVE_ID_DOMAIN_FILE_ID_COL = 0;
    static final int ARCHIVE_ID_NAME_COL = 1;
    static final int ARCHIVE_ID_TYPE_COL = 2;
    static final int ARCHIVE_ID_LAST_SYNC_TIME_COL = 3;
    static final int ARCHIVE_ID_DIRTY_FLAG_COL = 4;

    SourceArchiveAdapter() {
    }

    static SourceArchiveAdapter getAdapter(DBHandle handle, OpenMode openMode, String tablePrefix, TaskMonitor monitor) throws VersionException, IOException, CancelledException {
        if (openMode == OpenMode.CREATE) {
            return new SourceArchiveAdapterV0(handle, tablePrefix, true);
        }
        try {
            return new SourceArchiveAdapterV0(handle, tablePrefix, false);
        }
        catch (VersionException e) {
            if (!e.isUpgradable() || openMode == OpenMode.UPDATE) {
                throw e;
            }
            SourceArchiveAdapter adapter = SourceArchiveAdapter.findReadOnlyAdapter(handle);
            if (openMode == OpenMode.UPGRADE) {
                adapter = SourceArchiveAdapter.upgrade(handle, adapter, tablePrefix, monitor);
            }
            return adapter;
        }
    }

    private static SourceArchiveAdapter findReadOnlyAdapter(DBHandle handle) throws VersionException {
        return new SourceArchiveAdapterNoTable(handle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SourceArchiveAdapter upgrade(DBHandle handle, SourceArchiveAdapter oldAdapter, String tablePrefix, TaskMonitor monitor) throws VersionException, IOException, CancelledException {
        DBHandle tmpHandle = new DBHandle();
        long id = tmpHandle.startTransaction();
        SourceArchiveAdapterV0 tmpAdapter = null;
        try {
            tmpAdapter = new SourceArchiveAdapterV0(tmpHandle, tablePrefix, true);
            Iterator<DBRecord> it = oldAdapter.getRecords().iterator();
            while (it.hasNext()) {
                monitor.checkCancelled();
                DBRecord rec = it.next();
                ((SourceArchiveAdapter)tmpAdapter).updateRecord(rec);
            }
            oldAdapter.deleteTable(handle);
            SourceArchiveAdapterV0 newAdapter = new SourceArchiveAdapterV0(handle, tablePrefix, true);
            it = ((SourceArchiveAdapter)tmpAdapter).getRecords().iterator();
            while (it.hasNext()) {
                monitor.checkCancelled();
                DBRecord rec = it.next();
                ((SourceArchiveAdapter)newAdapter).updateRecord(rec);
            }
            SourceArchiveAdapterV0 sourceArchiveAdapterV0 = newAdapter;
            return sourceArchiveAdapterV0;
        }
        finally {
            tmpHandle.endTransaction(id, true);
            tmpHandle.close();
        }
    }

    abstract void deleteTable(DBHandle var1) throws IOException;

    abstract DBRecord createRecord(SourceArchive var1) throws IOException;

    abstract List<DBRecord> getRecords() throws IOException;

    abstract DBRecord getRecord(long var1) throws IOException;

    abstract void updateRecord(DBRecord var1) throws IOException;

    abstract boolean removeRecord(long var1) throws IOException;

    abstract void deleteRecord(UniversalID var1) throws IOException;
}

