/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.function;

import ghidra.program.database.data.DataTypeUtilities;
import ghidra.program.database.function.FunctionDB;
import ghidra.program.database.function.FunctionManagerDB;
import ghidra.program.database.symbol.SymbolDB;
import ghidra.program.database.symbol.VariableSymbolDB;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.VoidDataType;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Parameter;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.listing.VariableSizeException;
import ghidra.program.model.listing.VariableStorage;
import ghidra.program.model.listing.VariableUtilities;
import ghidra.program.model.pcode.Varnode;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.util.SystemUtilities;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public abstract class VariableDB
implements Variable {
    protected VariableSymbolDB symbol;
    protected VariableStorage storage;
    protected FunctionDB function;
    protected FunctionManagerDB functionMgr;

    VariableDB(FunctionDB function, SymbolDB s) {
        this.symbol = (VariableSymbolDB)s;
        this.function = function;
        this.functionMgr = function.getFunctionManager();
    }

    protected boolean isVoidAllowed() {
        return false;
    }

    @Override
    public final boolean isValid() {
        VariableStorage variableStorage = this.getVariableStorage();
        DataType dt = this.getDataType();
        if (VoidDataType.isVoidDataType(dt)) {
            return this.isVoidAllowed() && variableStorage.isVoidStorage();
        }
        if (dt.getLength() <= 0 || !variableStorage.isValid()) {
            return false;
        }
        return variableStorage.size() >= dt.getLength();
    }

    @Override
    public Program getProgram() {
        return this.function.getProgram();
    }

    @Override
    public DataType getDataType() {
        return this.symbol.getDataType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDataType(DataType type, VariableStorage newStorage, boolean force, SourceType source) throws InvalidInputException, VariableSizeException {
        this.functionMgr.lock.acquire();
        try {
            this.function.startUpdate();
            this.function.checkDeleted();
            if (this instanceof Parameter && !this.function.hasCustomVariableStorage()) {
                newStorage = VariableStorage.UNASSIGNED_STORAGE;
            }
            type = VariableUtilities.checkDataType(type, false, this.getLength(), this.function.getProgram());
            if (!(this instanceof Parameter) || this.function.hasCustomVariableStorage()) {
                newStorage = VariableUtilities.checkStorage(this.function, newStorage, type, force);
                VariableUtilities.checkVariableConflict(this.function, (Variable)this, newStorage, force);
                this.setStorageAndDataType(newStorage, type);
            } else {
                this.setStorageAndDataType(newStorage, type);
                this.function.updateParametersAndReturn();
            }
            if (this instanceof Parameter) {
                this.function.updateSignatureSourceAfterVariableChange(source, type);
            }
            this.function.dataTypeChanged(this);
        }
        finally {
            this.function.endUpdate();
            this.functionMgr.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDataType(DataType type, boolean alignStack, boolean force, SourceType source) throws InvalidInputException {
        this.functionMgr.lock.acquire();
        try {
            this.function.startUpdate();
            this.function.checkDeleted();
            type = VariableUtilities.checkDataType(type, false, this.getLength(), this.function.getProgram());
            VariableStorage newStorage = VariableStorage.UNASSIGNED_STORAGE;
            if (!(this instanceof Parameter) || this.function.hasCustomVariableStorage()) {
                try {
                    newStorage = VariableUtilities.resizeStorage(this.getVariableStorage(), type, alignStack, this.function);
                    VariableUtilities.checkStorage(newStorage, type, force);
                    VariableUtilities.checkVariableConflict(this.function, (Variable)this, newStorage, force);
                }
                catch (InvalidInputException e) {
                    if (!force) {
                        throw e;
                    }
                    newStorage = VariableStorage.UNASSIGNED_STORAGE;
                }
                this.setStorageAndDataType(newStorage, type);
            } else {
                this.setStorageAndDataType(newStorage, type);
                this.function.updateParametersAndReturn();
            }
            if (this instanceof Parameter) {
                this.function.updateSignatureSourceAfterVariableChange(source, type);
            }
            this.function.dataTypeChanged(this);
        }
        finally {
            this.function.endUpdate();
            this.functionMgr.lock.release();
        }
    }

    @Override
    public void setDataType(DataType type, SourceType source) throws InvalidInputException {
        this.setDataType(type, true, false, source);
    }

    @Override
    public String getName() {
        return this.symbol.getName();
    }

    @Override
    public int getLength() {
        return this.getDataType().getLength();
    }

    @Override
    public void setName(String name, SourceType source) throws DuplicateNameException, InvalidInputException {
        this.symbol.setName(name, source);
    }

    @Override
    public String getComment() {
        return this.symbol.getSymbolStringData();
    }

    @Override
    public void setComment(String comment) {
        this.symbol.setSymbolStringData(comment);
        this.functionMgr.functionChanged(this.function, null);
    }

    @Override
    public Function getFunction() {
        return this.function;
    }

    @Override
    public Symbol getSymbol() {
        return this.symbol;
    }

    public String toString() {
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append("[");
        strBuilder.append(this.getDataType().getName());
        strBuilder.append(" ");
        strBuilder.append(this.getName());
        strBuilder.append("@");
        strBuilder.append(this.getVariableStorage().toString());
        strBuilder.append("]");
        return strBuilder.toString();
    }

    @Override
    public SourceType getSource() {
        return this.symbol.getSource();
    }

    @Override
    public boolean hasAssignedStorage() {
        return !this.symbol.getVariableStorage().isUnassignedStorage();
    }

    @Override
    public VariableStorage getVariableStorage() {
        if (this.storage == null) {
            this.storage = this.symbol.getVariableStorage();
        }
        return this.storage;
    }

    void setDynamicStorage(VariableStorage storage) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Varnode getFirstStorageVarnode() {
        VariableStorage variableStorage = this.getVariableStorage();
        if (variableStorage != null) {
            return variableStorage.getFirstVarnode();
        }
        return null;
    }

    @Override
    public Varnode getLastStorageVarnode() {
        VariableStorage variableStorage = this.getVariableStorage();
        if (variableStorage != null) {
            return variableStorage.getLastVarnode();
        }
        return null;
    }

    @Override
    public boolean isStackVariable() {
        VariableStorage variableStorage = this.getVariableStorage();
        if (variableStorage != null) {
            return variableStorage.isStackStorage();
        }
        return false;
    }

    @Override
    public boolean hasStackStorage() {
        VariableStorage variableStorage = this.getVariableStorage();
        if (variableStorage != null) {
            return variableStorage.hasStackStorage();
        }
        return false;
    }

    @Override
    public boolean isRegisterVariable() {
        VariableStorage variableStorage = this.getVariableStorage();
        if (variableStorage != null) {
            return variableStorage.isRegisterStorage();
        }
        return false;
    }

    @Override
    public Register getRegister() {
        VariableStorage variableStorage = this.getVariableStorage();
        if (variableStorage != null) {
            return variableStorage.getRegister();
        }
        return null;
    }

    @Override
    public List<Register> getRegisters() {
        VariableStorage variableStorage = this.getVariableStorage();
        if (variableStorage != null) {
            return variableStorage.getRegisters();
        }
        return null;
    }

    @Override
    public Address getMinAddress() {
        VariableStorage variableStorage = this.getVariableStorage();
        if (variableStorage != null) {
            return variableStorage.getMinAddress();
        }
        return null;
    }

    @Override
    public int getStackOffset() {
        VariableStorage variableStorage = this.getVariableStorage();
        if (variableStorage != null) {
            return variableStorage.getStackOffset();
        }
        throw new UnsupportedOperationException("Variable is not a stack variable");
    }

    @Override
    public boolean isMemoryVariable() {
        VariableStorage variableStorage = this.getVariableStorage();
        if (variableStorage != null) {
            return variableStorage.isMemoryStorage();
        }
        return false;
    }

    @Override
    public boolean isUniqueVariable() {
        VariableStorage variableStorage = this.getVariableStorage();
        if (variableStorage != null) {
            return variableStorage.isHashStorage();
        }
        return false;
    }

    @Override
    public boolean isCompoundVariable() {
        VariableStorage variableStorage = this.getVariableStorage();
        return variableStorage != null && variableStorage.isCompoundStorage();
    }

    public int hashCode() {
        int hashcode = this.getFirstUseOffset();
        return hashcode ^= this.getVariableStorage().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Variable)) {
            return false;
        }
        Variable otherVar = (Variable)obj;
        if (!this.isEquivalent(otherVar)) {
            return false;
        }
        if (!StringUtils.equals((CharSequence)this.getName(), (CharSequence)otherVar.getName())) {
            return false;
        }
        return StringUtils.equals((CharSequence)this.getComment(), (CharSequence)otherVar.getComment());
    }

    @Override
    public int compareTo(Variable otherVar) {
        return VariableUtilities.compare(this, otherVar);
    }

    @Override
    public boolean isEquivalent(Variable otherVar) {
        boolean eitherHasCustomVariableStorage;
        if (otherVar == null) {
            return false;
        }
        if (otherVar == this) {
            return true;
        }
        if (otherVar instanceof Parameter != this instanceof Parameter) {
            return false;
        }
        if (this instanceof Parameter && ((Parameter)((Object)this)).getOrdinal() != ((Parameter)otherVar).getOrdinal()) {
            return false;
        }
        Function otherFunction = otherVar.getFunction();
        boolean bl = eitherHasCustomVariableStorage = this.function == null || this.function.hasCustomVariableStorage() || otherFunction == null || otherFunction.hasCustomVariableStorage();
        if (eitherHasCustomVariableStorage && !SystemUtilities.isEqual((Object)this.getVariableStorage(), (Object)otherVar.getVariableStorage())) {
            return false;
        }
        if (this.getFirstUseOffset() != otherVar.getFirstUseOffset()) {
            return false;
        }
        return DataTypeUtilities.isSameOrEquivalentDataType(this.getDataType(), otherVar.getDataType());
    }

    void setStorageAndDataType(VariableStorage newStorage, DataType dt) {
        if (this instanceof Parameter && !this.function.hasCustomVariableStorage()) {
            newStorage = VariableStorage.UNASSIGNED_STORAGE;
        }
        this.symbol.setStorageAndDataType(newStorage, dt);
        this.storage = newStorage;
    }
}

