/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.docking.settings.Settings;
import ghidra.docking.settings.SettingsDefinition;
import ghidra.program.model.data.AbstractIntegerDataType;
import ghidra.program.model.data.AbstractUnsignedIntegerDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.lang.DecompilerLanguage;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.MemoryAccessException;
import java.math.BigInteger;

public class BooleanDataType
extends AbstractUnsignedIntegerDataType {
    private static SettingsDefinition[] SETTINGS_DEFS = new SettingsDefinition[0];
    public static final BooleanDataType dataType = new BooleanDataType();

    public BooleanDataType() {
        this(null);
    }

    public BooleanDataType(DataTypeManager dtm) {
        super("bool", dtm);
    }

    @Override
    public String getMnemonic(Settings settings) {
        return "bool";
    }

    @Override
    public String getDecompilerDisplayName(DecompilerLanguage language) {
        if (language == DecompilerLanguage.JAVA_LANGUAGE) {
            return "boolean";
        }
        return this.name;
    }

    @Override
    public String getCDeclaration() {
        return this.name;
    }

    @Override
    public int getLength() {
        return 1;
    }

    @Override
    public String getDescription() {
        return "Boolean";
    }

    @Override
    public Object getValue(MemBuffer buf, Settings settings, int length) {
        try {
            return buf.getByte(0) != 0;
        }
        catch (MemoryAccessException e) {
            return null;
        }
    }

    @Override
    public Class<?> getValueClass(Settings settings) {
        return Boolean.class;
    }

    @Override
    public String getRepresentation(MemBuffer buf, Settings settings, int length) {
        Boolean b = (Boolean)this.getValue(buf, settings, length);
        if (b == null) {
            return "??";
        }
        return b != false ? "TRUE" : "FALSE";
    }

    @Override
    public String getRepresentation(BigInteger bigInt, Settings settings, int bitLength) {
        return BigInteger.ZERO.equals(bigInt) ? "FALSE" : "TRUE";
    }

    @Override
    protected SettingsDefinition[] getBuiltInSettingsDefinitions() {
        return SETTINGS_DEFS;
    }

    @Override
    public DataType clone(DataTypeManager dtm) {
        return new BooleanDataType(dtm);
    }

    @Override
    public String getDefaultLabelPrefix() {
        return "BOOL";
    }

    @Override
    public AbstractIntegerDataType getOppositeSignednessDataType() {
        return this;
    }
}

