/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.docking.settings.Settings;
import ghidra.program.model.data.BuiltIn;
import ghidra.program.model.data.ByteDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeDisplayOptions;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.Dynamic;
import ghidra.program.model.data.InvalidDataTypeException;
import ghidra.program.model.data.ScorePlayer;
import ghidra.program.model.mem.MemBuffer;
import ghidra.util.Msg;
import java.io.DataInputStream;
import java.io.EOFException;

public class MIDIDataType
extends BuiltIn
implements Dynamic {
    public static byte[] MAGIC = new byte[]{77, 84, 104, 100, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 77, 84, 114, 107};
    public static byte[] MAGIC_MASK = new byte[]{-1, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1, -1, -1};

    public MIDIDataType() {
        this(null);
    }

    public MIDIDataType(DataTypeManager dtm) {
        super(null, "MIDI-Score", dtm);
    }

    @Override
    public int getLength() {
        return -1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int getLength(MemBuffer buf, int maxLength) {
        try (DataInputStream stream = new DataInputStream(buf.getInputStream(0, maxLength > 0 ? maxLength : Integer.MAX_VALUE));){
            byte[] chunkType = new byte[4];
            if (stream.read(chunkType) < chunkType.length) {
                throw new EOFException();
            }
            if (chunkType[0] != 77 || chunkType[1] != 84 || chunkType[2] != 104 || chunkType[3] != 100) {
                int n = -1;
                return n;
            }
            long chunkLength = Integer.toUnsignedLong(stream.readInt());
            if (chunkLength != 6L) {
                throw new InvalidDataTypeException("Unexpected header length.");
            }
            stream.skip(2L);
            int tracks = Short.toUnsignedInt(stream.readShort());
            stream.skip(2L);
            int computedLength = 14;
            while (tracks > 0) {
                if (stream.read(chunkType) < chunkType.length) {
                    throw new EOFException();
                }
                chunkLength = Integer.toUnsignedLong(stream.readInt());
                stream.skip(chunkLength);
                computedLength = (int)((long)computedLength + (8L + chunkLength));
                if (chunkType[0] != 77 || chunkType[1] != 84 || chunkType[2] != 114 || chunkType[3] != 107) continue;
                --tracks;
            }
            int n = computedLength;
            return n;
        }
        catch (Exception e) {
            Msg.debug((Object)this, (Object)("Invalid MIDI data at " + String.valueOf(buf.getAddress())));
            return -1;
        }
    }

    @Override
    public boolean canSpecifyLength() {
        return false;
    }

    @Override
    public DataType clone(DataTypeManager dtm) {
        if (dtm == this.getDataTypeManager()) {
            return this;
        }
        return new MIDIDataType(dtm);
    }

    @Override
    public String getDescription() {
        return "MIDI score stored within program";
    }

    @Override
    public String getMnemonic(Settings settings) {
        return "MIDI";
    }

    @Override
    public String getRepresentation(MemBuffer buf, Settings settings, int length) {
        return "<MIDI-Resource>";
    }

    @Override
    public Object getValue(MemBuffer buf, Settings settings, int length) {
        byte[] data = new byte[length];
        if (buf.getBytes(data, 0) != length) {
            Msg.error((Object)this, (Object)"MIDI-Score error: Not enough bytes!");
            return null;
        }
        return new ScorePlayer(data);
    }

    @Override
    public Class<?> getValueClass(Settings settings) {
        return ScorePlayer.class;
    }

    @Override
    public String getDefaultLabelPrefix(MemBuffer buf, Settings settings, int len, DataTypeDisplayOptions options) {
        return "MIDI";
    }

    @Override
    public DataType getReplacementBaseType() {
        return ByteDataType.dataType;
    }
}

