/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.lang.protorules;

import ghidra.program.model.lang.PrototypePieces;
import ghidra.program.model.lang.protorules.DatatypeMatchFilter;
import ghidra.program.model.lang.protorules.PositionMatchFilter;
import ghidra.program.model.lang.protorules.VarargsFilter;
import ghidra.program.model.pcode.ElementId;
import ghidra.program.model.pcode.Encoder;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlParseException;
import ghidra.xml.XmlPullParser;
import java.io.IOException;

public interface QualifierFilter {
    public QualifierFilter clone();

    public boolean isEquivalent(QualifierFilter var1);

    public boolean filter(PrototypePieces var1, int var2);

    public void encode(Encoder var1) throws IOException;

    public void restoreXml(XmlPullParser var1) throws XmlParseException;

    public static QualifierFilter restoreFilterXml(XmlPullParser parser) throws XmlParseException {
        QualifierFilter filter;
        XmlElement elemId = parser.peek();
        String nm = elemId.getName();
        if (nm.equals(ElementId.ELEM_VARARGS.name())) {
            filter = new VarargsFilter();
        } else if (nm.equals(ElementId.ELEM_POSITION.name())) {
            filter = new PositionMatchFilter(-1);
        } else if (nm.equals(ElementId.ELEM_DATATYPE_AT.name())) {
            filter = new DatatypeMatchFilter();
        } else {
            return null;
        }
        filter.restoreXml(parser);
        return filter;
    }
}

