/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.pcode;

import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.Undefined;
import ghidra.program.model.data.VoidDataType;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.Language;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Parameter;
import ghidra.program.model.listing.ParameterImpl;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.pcode.AddressXML;
import ghidra.program.model.pcode.AttributeId;
import ghidra.program.model.pcode.Decoder;
import ghidra.program.model.pcode.DecoderException;
import ghidra.program.model.pcode.ElementId;
import ghidra.program.model.pcode.ParamMeasure;
import ghidra.program.model.pcode.PcodeDataTypeManager;
import ghidra.program.model.pcode.PcodeSyntaxTree;
import ghidra.program.model.pcode.Varnode;
import ghidra.program.model.symbol.SourceType;
import ghidra.util.Msg;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class HighParamID
extends PcodeSyntaxTree {
    public static final String DECOMPILER_TAG_MAP = "decompiler_tags";
    private Function func;
    private String functionname;
    private Address functionaddress;
    private String modelname;
    private Integer protoextrapop;
    private List<ParamMeasure> inputlist = new ArrayList<ParamMeasure>();
    private List<ParamMeasure> outputlist = new ArrayList<ParamMeasure>();

    public HighParamID(Function function, Language language, CompilerSpec compilerSpec, PcodeDataTypeManager dtManager) {
        super(function.getProgram().getAddressFactory(), dtManager);
        this.func = function;
        this.modelname = null;
        this.protoextrapop = 32768;
    }

    public String getFunctionName() {
        return this.functionname;
    }

    public Address getFunctionAddress() {
        return this.functionaddress;
    }

    public String getModelName() {
        return this.modelname;
    }

    public Integer getProtoExtraPop() {
        return this.protoextrapop;
    }

    public Function getFunction() {
        return this.func;
    }

    public int getNumInputs() {
        return this.inputlist.size();
    }

    public ParamMeasure getInput(int i) {
        return this.inputlist.get(i);
    }

    public int getNumOutputs() {
        return this.outputlist.size();
    }

    public ParamMeasure getOutput(int i) {
        return this.outputlist.get(i);
    }

    @Override
    public void decode(Decoder decoder) throws DecoderException {
        int subel;
        int start = decoder.openElement(ElementId.ELEM_PARAMMEASURES);
        this.functionname = decoder.readString(AttributeId.ATTRIB_NAME);
        if (!this.func.getName().equals(this.functionname)) {
            throw new DecoderException("Function name mismatch: " + this.func.getName() + " + " + this.functionname);
        }
        while ((subel = decoder.peekElement()) != 0) {
            if (subel == ElementId.ELEM_ADDR.id()) {
                this.functionaddress = AddressXML.decode(decoder);
                if (this.func.getEntryPoint().equals(this.functionaddress)) continue;
                throw new DecoderException("Mismatched address in function tag");
            }
            if (subel == ElementId.ELEM_PROTO.id()) {
                decoder.openElement();
                this.modelname = decoder.readString(AttributeId.ATTRIB_MODEL);
                this.protoextrapop = (int)decoder.readSignedIntegerExpectString(AttributeId.ATTRIB_EXTRAPOP, "unknown", 32768L);
                decoder.closeElement(subel);
                continue;
            }
            if (subel == ElementId.ELEM_INPUT.id()) {
                this.decodeParamMeasure(decoder, this.inputlist);
                continue;
            }
            if (subel == ElementId.ELEM_OUTPUT.id()) {
                this.decodeParamMeasure(decoder, this.outputlist);
                continue;
            }
            throw new DecoderException("Unknown tag in parammeasures");
        }
        decoder.closeElement(start);
    }

    private void decodeParamMeasure(Decoder decoder, List<ParamMeasure> pmlist) throws DecoderException {
        int el = decoder.openElement();
        ParamMeasure pm = new ParamMeasure();
        pm.decode(decoder, this);
        if (!pm.isEmpty()) {
            pmlist.add(pm);
        }
        decoder.closeElement(el);
    }

    public static ErrorHandler getErrorHandler(final Object errOriginator, final String targetName) {
        return new ErrorHandler(){

            @Override
            public void error(SAXParseException exception) throws SAXException {
                Msg.error((Object)errOriginator, (Object)("Error parsing " + targetName), (Throwable)exception);
            }

            @Override
            public void fatalError(SAXParseException exception) throws SAXException {
                Msg.error((Object)errOriginator, (Object)("Fatal error parsing " + targetName), (Throwable)exception);
            }

            @Override
            public void warning(SAXParseException exception) throws SAXException {
                Msg.warn((Object)errOriginator, (Object)("Warning parsing " + targetName), (Throwable)exception);
            }
        };
    }

    public void storeReturnToDatabase(boolean storeDataTypes, SourceType srctype) {
        try {
            int best_index = 0;
            if (this.getNumOutputs() > 1) {
                for (int i = 1; i < this.getNumOutputs(); ++i) {
                    if (this.getOutput(i).getRank() >= this.getOutput(best_index).getRank()) continue;
                    best_index = i;
                }
            }
            if (this.getNumOutputs() != 0) {
                ParamMeasure pm = this.getOutput(best_index);
                pm.getRank();
                Varnode vn = pm.getVarnode();
                DataType dataType = storeDataTypes ? pm.getDataType() : Undefined.getUndefinedDataType(vn.getSize());
                if (dataType != null && !(dataType instanceof VoidDataType)) {
                    this.func.setReturn(dataType, this.buildStorage(vn), SourceType.ANALYSIS);
                }
            }
        }
        catch (InvalidInputException e) {
            Msg.error((Object)this, (Object)e.getMessage());
        }
    }

    public void storeParametersToDatabase(boolean storeDataTypes, SourceType srctype) {
        try {
            ArrayList<Variable> params = new ArrayList<Variable>();
            for (ParamMeasure pm : this.inputlist) {
                Varnode vn = pm.getVarnode();
                DataType dataType = storeDataTypes ? pm.getDataType() : Undefined.getUndefinedDataType(vn.getSize());
                ParameterImpl v = new ParameterImpl(null, dataType, this.buildStorage(vn), this.func.getProgram());
                params.add(v);
            }
            this.func.updateFunction(this.modelname, null, params, Function.FunctionUpdateType.DYNAMIC_STORAGE_ALL_PARAMS, true, srctype);
            if (!this.paramStorageMatches(this.func, params)) {
                this.func.updateFunction(this.modelname, null, params, Function.FunctionUpdateType.CUSTOM_STORAGE, true, srctype);
            }
        }
        catch (InvalidInputException e) {
            Msg.error((Object)this, (Object)e.getMessage());
        }
        catch (DuplicateNameException e) {
            Msg.error((Object)this, (Object)e.getMessage());
        }
    }

    private boolean paramStorageMatches(Function function, List<Variable> params) {
        Parameter[] parameters = function.getParameters();
        if (parameters.length != params.size()) {
            return false;
        }
        for (int i = 0; i < parameters.length; ++i) {
            if (parameters[i].getVariableStorage().equals(params.get(i).getVariableStorage())) continue;
            return false;
        }
        return true;
    }
}

