/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.api.db;

import db.DBHandle;
import db.DBRecord;
import db.Field;
import db.LongField;
import db.RecordIterator;
import db.Schema;
import db.Table;
import ghidra.feature.vt.api.db.VTMatchSetTableDBAdapter;
import ghidra.feature.vt.api.main.VTProgramCorrelator;
import ghidra.framework.data.OpenMode;
import ghidra.framework.options.ToolOptions;
import ghidra.program.database.map.AddressMap;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.KeyRange;
import ghidra.program.model.listing.Program;
import ghidra.util.exception.VersionException;
import ghidra.util.xml.GenericXMLOutputter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.jdom.Element;

public class VTMatchSetTableDBAdapterV0
extends VTMatchSetTableDBAdapter {
    private Table table;
    private static final Schema STORED_ADDRESS_RANGE_SCHEMA = new Schema(0, "Key", new Field[]{LongField.INSTANCE, LongField.INSTANCE}, new String[]{"addr1", "addr2"});
    private final DBHandle dbHandle;

    public VTMatchSetTableDBAdapterV0(DBHandle dbHandle) throws IOException {
        this.dbHandle = dbHandle;
        this.table = dbHandle.createTable(TABLE_NAME, TABLE_SCHEMA);
    }

    public VTMatchSetTableDBAdapterV0(DBHandle dbHandle, OpenMode openMode) throws VersionException {
        this.dbHandle = dbHandle;
        this.table = dbHandle.getTable(TABLE_NAME);
        if (this.table == null) {
            throw new VersionException("Missing Table: " + TABLE_NAME);
        }
        if (this.table.getSchema().getVersion() != 0) {
            throw new VersionException("Expected version 0 for table " + TABLE_NAME + " but got " + this.table.getSchema().getVersion());
        }
    }

    @Override
    public DBRecord createMatchSetRecord(long key, VTProgramCorrelator correlator) throws IOException {
        DBRecord record = TABLE_SCHEMA.createRecord(key);
        record.setString(VTMatchSetTableDBAdapter.ColumnDescription.CORRELATOR_CLASS_COL.column(), correlator.getClass().getName());
        record.setString(VTMatchSetTableDBAdapter.ColumnDescription.CORRELATOR_NAME_COL.column(), correlator.getName());
        record.setString(VTMatchSetTableDBAdapter.ColumnDescription.OPTIONS_COL.column(), this.getOptionsString(correlator));
        this.createSourceAddressSetTable(correlator, record);
        this.createDestinationAddressSetTable(correlator, record);
        this.table.putRecord(record);
        return record;
    }

    private String getOptionsString(VTProgramCorrelator correlator) {
        ToolOptions options = correlator.getOptions();
        if (options.getOptionNames().isEmpty()) {
            return null;
        }
        Element optionsElement = options.getXmlRoot(true);
        GenericXMLOutputter xmlout = new GenericXMLOutputter();
        StringWriter writer = new StringWriter();
        try {
            xmlout.output(optionsElement, (Writer)writer);
            return writer.toString();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private void createSourceAddressSetTable(VTProgramCorrelator correlator, DBRecord record) throws IOException {
        Program program = correlator.getSourceProgram();
        AddressSetView addressSet = correlator.getSourceAddressSet();
        String tableName = this.getSourceTableName(record);
        this.writeAddressSet(addressSet, tableName, program.getAddressMap());
    }

    private void createDestinationAddressSetTable(VTProgramCorrelator correlator, DBRecord record) throws IOException {
        Program program = correlator.getDestinationProgram();
        AddressSetView addressSet = correlator.getDestinationAddressSet();
        String tableName = this.getDestinationTableName(record);
        this.writeAddressSet(addressSet, tableName, program.getAddressMap());
    }

    private String getSourceTableName(DBRecord record) {
        return "Source Address Set " + record.getKey();
    }

    private String getDestinationTableName(DBRecord record) {
        return "Destination Address Set " + record.getKey();
    }

    @Override
    public RecordIterator getRecords() throws IOException {
        return this.table.iterator();
    }

    @Override
    public DBRecord getRecord(long key) throws IOException {
        return this.table.getRecord(key);
    }

    private void writeAddressSet(AddressSetView set, String tableName, AddressMap addressMap) throws IOException {
        if (set != null) {
            Table addressSetTable = this.dbHandle.createTable(tableName, STORED_ADDRESS_RANGE_SCHEMA);
            DBRecord rec = STORED_ADDRESS_RANGE_SCHEMA.createRecord(0L);
            int rangeKey = 1;
            for (KeyRange range : addressMap.getKeyRanges(set, false, false)) {
                rec.setKey((long)rangeKey++);
                rec.setLongValue(0, range.minKey);
                rec.setLongValue(1, range.maxKey);
                addressSetTable.putRecord(rec);
            }
        }
    }

    @Override
    public AddressSet getDestinationAddressSet(DBRecord record, AddressMap addressMap) throws IOException {
        return this.readAddressSet(record, this.getDestinationTableName(record), addressMap);
    }

    @Override
    public AddressSet getSourceAddressSet(DBRecord record, AddressMap addressMap) throws IOException {
        return this.readAddressSet(record, this.getSourceTableName(record), addressMap);
    }

    private AddressSet readAddressSet(DBRecord record, String tableName, AddressMap addressMap) throws IOException {
        Table addressSetTable = this.dbHandle.getTable(tableName);
        if (addressSetTable == null) {
            return null;
        }
        AddressSet addressSet = new AddressSet();
        for (DBRecord rec : addressSetTable) {
            Address addr1 = addressMap.decodeAddress(rec.getLongValue(0));
            Address addr2 = addressMap.decodeAddress(rec.getLongValue(1));
            addressSet.addRange(addr1, addr2);
        }
        return addressSet;
    }

    @Override
    public long getNextMatchSetID() {
        return this.table.getKey();
    }
}

