/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.api.db;

import db.DBHandle;
import db.DBRecord;
import db.Field;
import db.RecordIterator;
import db.Schema;
import db.StringField;
import ghidra.feature.vt.api.db.VTMatchTagDBAdapterV0;
import ghidra.framework.data.OpenMode;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.LinkedList;

public abstract class VTMatchTagDBAdapter {
    static String TABLE_NAME = "MatchTagTable";
    static Schema TABLE_SCHEMA = new Schema(0, "Key", ColumnDescription.getColumnFields(), ColumnDescription.getColumnNames());

    static VTMatchTagDBAdapter createAdapter(DBHandle dbHandle) throws IOException {
        return new VTMatchTagDBAdapterV0(dbHandle);
    }

    static VTMatchTagDBAdapter getAdapter(DBHandle dbHandle, OpenMode openMode, TaskMonitor monitor) throws VersionException {
        return new VTMatchTagDBAdapterV0(dbHandle, openMode, monitor);
    }

    public abstract DBRecord insertRecord(String var1) throws IOException;

    public abstract RecordIterator getRecords() throws IOException;

    abstract DBRecord getRecord(long var1) throws IOException;

    abstract int getRecordCount();

    abstract void updateRecord(DBRecord var1) throws IOException;

    abstract boolean deleteRecord(long var1) throws IOException;

    public static enum ColumnDescription {
        TAG_NAME_COL((Field)StringField.INSTANCE);

        private final Field columnField;

        private ColumnDescription(Field columnField) {
            this.columnField = columnField;
        }

        public Field getColumnField() {
            return this.columnField;
        }

        public int column() {
            return this.ordinal();
        }

        private static String[] getColumnNames() {
            ColumnDescription[] columns = ColumnDescription.values();
            LinkedList<String> list = new LinkedList<String>();
            for (ColumnDescription column : columns) {
                list.add(column.name());
            }
            return list.toArray(new String[columns.length]);
        }

        private static Field[] getColumnFields() {
            ColumnDescription[] columns = ColumnDescription.values();
            Field[] fields = new Field[columns.length];
            for (int i = 0; i < fields.length; ++i) {
                fields[i] = columns[i].getColumnField();
            }
            return fields;
        }
    }
}

