/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.actions;

import docking.action.MenuData;
import docking.action.ToolBarData;
import ghidra.feature.vt.api.main.VTMarkupItemApplyActionType;
import ghidra.feature.vt.gui.actions.AbstractMarkupItemAction;
import ghidra.feature.vt.gui.plugin.VTController;
import ghidra.feature.vt.gui.plugin.VTPlugin;
import ghidra.feature.vt.gui.util.VTMatchApplyChoices;
import ghidra.framework.options.ToolOptions;
import ghidra.util.HelpLocation;
import javax.swing.Icon;

public class ReplaceFirstMarkupItemAction
extends AbstractMarkupItemAction {
    private static final String MENU_GROUP = "A_VT_Apply_Edit";

    public ReplaceFirstMarkupItemAction(VTController controller, boolean addToToolbar) {
        super(controller, "Apply (Replace First Only)");
        Icon replacedIcon = VTPlugin.REPLACED_ICON;
        if (addToToolbar) {
            this.setToolBarData(new ToolBarData(replacedIcon, MENU_GROUP));
        }
        MenuData menuData = new MenuData(new String[]{"Apply (Replace First Only)"}, replacedIcon, MENU_GROUP);
        menuData.setMenuSubGroup("2");
        this.setPopupMenuData(menuData);
        this.setEnabled(false);
        this.setHelpLocation(new HelpLocation("VersionTrackingPlugin", "Replace_First_Markup_Item"));
    }

    @Override
    public ToolOptions getApplyOptions() {
        ToolOptions options = this.controller.getOptions();
        ToolOptions vtOptions = options.copy();
        vtOptions.setEnum("Apply Markup Options.Data Match Data Type", (Enum)VTMatchApplyChoices.ReplaceDataChoices.REPLACE_FIRST_DATA_ONLY);
        return vtOptions;
    }

    @Override
    public VTMarkupItemApplyActionType getActionType() {
        return VTMarkupItemApplyActionType.REPLACE_FIRST_ONLY;
    }
}

