/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.provider.markuptable;

import docking.widgets.checkbox.GCheckBox;
import ghidra.feature.vt.api.main.VTMarkupItem;
import ghidra.feature.vt.api.markuptype.VTMarkupType;
import ghidra.feature.vt.api.markuptype.VTMarkupTypeFactory;
import ghidra.feature.vt.gui.filters.CheckBoxBasedAncillaryFilter;
import ghidra.feature.vt.gui.filters.CheckBoxInfo;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import javax.swing.JCheckBox;

public class MarkupTypeFilter
extends CheckBoxBasedAncillaryFilter<VTMarkupItem> {
    public MarkupTypeFilter() {
        super("Markup Type");
    }

    @Override
    protected void createCheckBoxInfos() {
        ItemListener listener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                MarkupTypeFilter.this.fireStatusChanged(MarkupTypeFilter.this.getFilterStatus());
            }
        };
        List<VTMarkupType> markupTypes = VTMarkupTypeFactory.getMarkupTypes();
        for (VTMarkupType markupType : markupTypes) {
            GCheckBox checkBox = new GCheckBox(markupType.getDisplayName());
            checkBox.setSelected(true);
            checkBox.addItemListener(listener);
            MarkupTypeCheckBoxInfo info = new MarkupTypeCheckBoxInfo(this, (JCheckBox)checkBox, markupType);
            this.checkBoxInfos.add(info);
        }
    }

    private class MarkupTypeCheckBoxInfo
    extends CheckBoxInfo<VTMarkupItem> {
        private VTMarkupType markupType;

        public MarkupTypeCheckBoxInfo(MarkupTypeFilter markupTypeFilter, JCheckBox checkBox, VTMarkupType markupType) {
            super(checkBox);
            this.markupType = markupType;
        }

        @Override
        public boolean matchesStatus(VTMarkupItem adapter) {
            if (!this.isSelected()) {
                return false;
            }
            return adapter.getMarkupType().equals(this.markupType);
        }
    }
}

