/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.provider.matchtable;

import docking.widgets.table.GTableCellRenderingData;
import generic.theme.GColor;
import ghidra.feature.vt.api.main.VTAssociation;
import ghidra.feature.vt.api.main.VTAssociationStatus;
import ghidra.feature.vt.api.main.VTMatch;
import ghidra.util.table.CompositeGhidraTableCellRenderer;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JTable;

public class MatchTableRenderer
extends CompositeGhidraTableCellRenderer {
    private static final Color LOCKED_OUT_BACKGROUND_COLOR = new GColor("color.bg.version.tracking.match.table.locked.out");

    public Component getTableCellRendererComponent(GTableCellRenderingData data) {
        Component rendererComponent = super.getTableCellRendererComponent(data);
        JTable table = data.getTable();
        Object rowObject = data.getRowObject();
        boolean isSelected = data.isSelected();
        VTMatch match = (VTMatch)rowObject;
        if (match == null) {
            return rendererComponent;
        }
        VTAssociation association = match.getAssociation();
        if (!isSelected && association != null) {
            rendererComponent.setBackground(MatchTableRenderer.getBackgroundColor(association, table, rendererComponent.getBackground()));
        }
        return rendererComponent;
    }

    public static Color getBackgroundColor(VTAssociation association, JTable table, Color defaultBackgroundColor) {
        VTAssociationStatus status = association.getStatus();
        if (status == VTAssociationStatus.BLOCKED) {
            return LOCKED_OUT_BACKGROUND_COLOR;
        }
        return defaultBackgroundColor;
    }
}

