/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.C11LinesStartEnd;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbReaderUtils;
import ghidra.app.util.bin.format.pdb2.pdbreader.StringParseType;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

public class C11Lines {
    private AbstractPdb pdb;
    private int cFile;
    private int cSeg;
    private List<Integer> baseSrcFile;
    private List<C11LinesStartEnd> startEnd;
    private List<Integer> seg;
    private List<Integer> ccSegs;
    private List<List<Integer>> baseSrcLines;
    private List<List<C11LinesStartEnd>> startEnds;
    private List<String> names;
    private List<List<Integer>> segmentNumbers;
    private List<List<List<Long>>> offsets;
    private List<List<List<Integer>>> lineNumbers;

    public static C11Lines parse(AbstractPdb pdb, PdbByteReader reader) throws PdbException, CancelledException {
        return new C11Lines(pdb, reader);
    }

    public int getNumFiles() {
        return this.cFile;
    }

    public int getNumSegments() {
        return this.cSeg;
    }

    public List<Integer> getSegments() {
        return this.seg;
    }

    public List<C11LinesStartEnd> getStartEnd() {
        return this.startEnd;
    }

    public List<Integer> getBaseSrcFiles() {
        return this.baseSrcFile;
    }

    public List<Integer> getPerFileNumSegments() {
        return this.ccSegs;
    }

    public List<List<Integer>> getPerFileBaseSrcLines() {
        return this.baseSrcLines;
    }

    public List<List<C11LinesStartEnd>> getPerFileStartEndRecords() {
        return this.startEnds;
    }

    public List<String> getFileNames() {
        return this.names;
    }

    public List<List<Integer>> getPerFileSegmentNumbers() {
        return this.segmentNumbers;
    }

    public List<List<List<Long>>> getPerFilePerSegmentOffsets() {
        return this.offsets;
    }

    public List<List<List<Integer>>> getPerFilePerSegmentLineNumbers() {
        return this.lineNumbers;
    }

    private C11Lines(AbstractPdb pdb, PdbByteReader reader) throws PdbException, CancelledException {
        int i;
        this.pdb = pdb;
        if (reader.numRemaining() < 4) {
            return;
        }
        this.cFile = reader.parseUnsignedShortVal();
        this.cSeg = reader.parseUnsignedShortVal();
        this.baseSrcFile = new ArrayList<Integer>();
        this.startEnd = new ArrayList<C11LinesStartEnd>();
        this.seg = new ArrayList<Integer>();
        for (i = 0; i < this.cFile; ++i) {
            pdb.checkCancelled();
            int val = reader.parseInt();
            if (val < 0) {
                throw new PdbException("beyond our max integer limitation");
            }
            this.baseSrcFile.add(val);
        }
        for (i = 0; i < this.cSeg; ++i) {
            pdb.checkCancelled();
            C11LinesStartEnd se = new C11LinesStartEnd();
            se.parse(reader);
            this.startEnd.add(se);
        }
        for (i = 0; i < this.cSeg; ++i) {
            pdb.checkCancelled();
            this.seg.add(reader.parseUnsignedShortVal());
        }
        this.ccSegs = new ArrayList<Integer>();
        this.baseSrcLines = new ArrayList<List<Integer>>();
        this.startEnds = new ArrayList<List<C11LinesStartEnd>>();
        this.names = new ArrayList<String>();
        this.segmentNumbers = new ArrayList<List<Integer>>();
        this.offsets = new ArrayList<List<List<Long>>>();
        this.lineNumbers = new ArrayList<List<List<Integer>>>();
        for (i = 0; i < this.cFile; ++i) {
            pdb.checkCancelled();
            reader.setIndex(this.baseSrcFile.get(i));
            int ccSeg = reader.parseUnsignedShortVal();
            this.ccSegs.add(ccSeg);
            reader.skip(2);
            ArrayList<Integer> baseSrcLn = new ArrayList<Integer>();
            for (int j = 0; j < ccSeg; ++j) {
                pdb.checkCancelled();
                baseSrcLn.add(reader.parseInt());
            }
            this.baseSrcLines.add(baseSrcLn);
            ArrayList<C11LinesStartEnd> myStartEnd = new ArrayList<C11LinesStartEnd>();
            for (int j = 0; j < ccSeg; ++j) {
                C11LinesStartEnd se = new C11LinesStartEnd();
                se.parse(reader);
                myStartEnd.add(se);
            }
            this.startEnds.add(myStartEnd);
            String name = reader.parseString(pdb, StringParseType.StringNt);
            this.names.add(name);
            ArrayList<Integer> segNums = new ArrayList<Integer>();
            ArrayList fileSegOffsets = new ArrayList();
            ArrayList fileSegLineNums = new ArrayList();
            for (int j = 0; j < ccSeg; ++j) {
                pdb.checkCancelled();
                reader.setIndex((Integer)baseSrcLn.get(j));
                int segNum = reader.parseUnsignedShortVal();
                segNums.add(segNum);
                int cPair = reader.parseUnsignedShortVal();
                ArrayList<Long> segOffsets = new ArrayList<Long>();
                for (int k = 0; k < cPair; ++k) {
                    pdb.checkCancelled();
                    segOffsets.add(reader.parseUnsignedIntVal());
                }
                fileSegOffsets.add(segOffsets);
                ArrayList<Integer> segLineNums = new ArrayList<Integer>();
                for (int k = 0; k < cPair; ++k) {
                    pdb.checkCancelled();
                    segLineNums.add(reader.parseUnsignedShortVal());
                }
                fileSegLineNums.add(segLineNums);
            }
            this.segmentNumbers.add(segNums);
            this.offsets.add(fileSegOffsets);
            this.lineNumbers.add(fileSegLineNums);
        }
    }

    public String toString() {
        return String.format("%s: numFiles = %d, numSegs = %d", this.getClass().getSimpleName(), this.cFile, this.cSeg);
    }

    void dump(Writer writer, TaskMonitor monitor) throws CancelledException, IOException {
        int i;
        PdbReaderUtils.dumpHead(writer, this);
        writer.write("cFile: " + this.cFile + " cSeg: " + this.cSeg + "\n");
        for (i = 0; i < this.cFile; ++i) {
            this.pdb.checkCancelled();
            writer.write("baseSrcFile[" + i + "]: " + String.valueOf(this.baseSrcFile.get(i)) + "\n");
        }
        for (i = 0; i < this.cSeg; ++i) {
            this.pdb.checkCancelled();
            writer.write(i + ": start:" + this.startEnd.get(i).getStart() + " end: " + this.startEnd.get(i).getEnd() + " seg: " + String.valueOf(this.seg.get(i)) + "\n");
        }
        for (i = 0; i < this.cFile; ++i) {
            this.pdb.checkCancelled();
            writer.write("  file[" + i + "]: cSeg: " + String.valueOf(this.ccSegs.get(i)) + " name: " + this.names.get(i) + "\n");
            List<Integer> myBaseSrcLn = this.baseSrcLines.get(i);
            List<C11LinesStartEnd> myStartEnds = this.startEnds.get(i);
            for (int j = 0; j < this.ccSegs.get(i); ++j) {
                C11LinesStartEnd se = myStartEnds.get(j);
                writer.write("  " + j + ": baseSrcLn: " + String.valueOf(myBaseSrcLn.get(j)) + " start: " + se.getStart() + " end: " + se.getEnd() + "\n");
            }
            List<Integer> segNums = this.segmentNumbers.get(i);
            List<List<Long>> fileSegOffsets = this.offsets.get(i);
            List<List<Integer>> fileSegLineNums = this.lineNumbers.get(i);
            for (int j = 0; j < fileSegOffsets.size(); ++j) {
                this.pdb.checkCancelled();
                List<Long> segOffsets = fileSegOffsets.get(j);
                List<Integer> segLineNums = fileSegLineNums.get(j);
                writer.write("  seg[" + j + "]: Seg: " + String.valueOf(segNums.get(j)) + " cPair: " + segOffsets.size() + "\n");
                for (int k = 0; k < segOffsets.size(); ++k) {
                    writer.write("  " + String.valueOf(segLineNums.get(k)) + ":" + String.valueOf(segOffsets.get(k)) + "\n");
                }
            }
        }
        PdbReaderUtils.dumpTail(writer, this);
    }
}

