/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader;

import java.util.HashMap;
import java.util.Map;

public enum Processor {
    UNKNOWN("???", -1),
    I8080("8080", 0),
    I8086("8086", 1),
    I80286("80286", 2),
    I80386("80386", 3),
    I80486("80486", 4),
    PENTIUM("Pentium", 5),
    PENTIUMPRO_PENTIUMII("Pentium Pro/Pentium II", 6),
    PENTIUMIII("Pentium III", 7),
    MIPS_MIPSR4000("MIPS (Generic)/R4000", 16),
    MIPS16("MIPS16", 17),
    MIPS32("MIPS32", 18),
    MIPS64("MIPS64", 19),
    MIPSI("MIPS I", 20),
    MIPSII("MIPS II", 21),
    MIPSIII("MIPS III", 22),
    MIPSIV("MIPS IV", 23),
    MIPSV("MIPS V", 24),
    M68000("M68000", 32),
    M68010("M68010", 33),
    M68020("M68020", 34),
    M68030("M68030", 35),
    M68040("M68040", 36),
    ALPHA_21064("Alpha/Alpha 21064", 48),
    ALPHA_21164("Alpha 21164", 49),
    ALPHA_21164A("Alpha 21164a", 50),
    ALPHA_21264("Alpha 21264", 51),
    ALPHA_21364("Alpha 21364", 52),
    PPC601("PPC 601", 64),
    PPC603("PPC 603", 65),
    PPC604("PPC 604", 66),
    PPC620("PPC 620", 67),
    PPCFP("PPC w/FP", 68),
    PPCBE("PPC (Big Endian)", 69),
    SH3("SH3", 80),
    SH3E("SH3E", 81),
    SH3DSP("SH3DSP", 82),
    SH4("SH4", 83),
    SHMEDIA("SHmedia", 84),
    ARM3("ARMv3 (CE)", 96),
    ARM4("ARMv4 (CE)", 97),
    ARM4T("ARMv4T (CE)", 98),
    ARM5("ARMv5 (CE)", 99),
    ARM5T("ARMv5T (CE)", 100),
    ARM6("ARMv6 (CE)", 101),
    ARM_XMAC("ARM (XMAC) (CE)", 102),
    ARM_WMMX("ARM (XMMX) (CE)", 103),
    ARM7("ARMv7 (CE)", 104),
    OMNI("Omni", 112),
    IA64_IA64_1("Itanium", 128),
    IA64_2("Itanium (McKinley)", 129),
    CEE("CEE", 144),
    AM33("AM33", 160),
    M32R("M32R", 176),
    TRICORE("TriCore", 192),
    X64_AMD64("x64", 208),
    EBC("EBC", 224),
    THUMB("Thumb (CE)", 240),
    ARMNT("ARM", 244),
    ARM64("ARM64", 246),
    D3D11_SHADER("D3D11_SHADER", 256),
    UNK1AB("Unknown1ab", 427),
    UNK304("Unknown304", 772);

    private static final Map<Integer, Processor> BY_VALUE;
    public final String label;
    private final int value;

    public String toString() {
        return this.label;
    }

    public int getValue() {
        return this.value;
    }

    public static Processor fromValue(int val) {
        return BY_VALUE.getOrDefault(val, UNKNOWN);
    }

    private Processor(String label, int value) {
        this.label = label;
        this.value = value;
    }

    static {
        BY_VALUE = new HashMap<Integer, Processor>();
        for (Processor val : Processor.values()) {
            BY_VALUE.put(val.value, val);
        }
    }
}

