/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.symbol;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractParsableItem;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;

public class AddressGap
extends AbstractParsableItem {
    private int gapStartOffset;
    private int lengthRange;

    public AddressGap(PdbByteReader reader) throws PdbException {
        this.gapStartOffset = reader.parseUnsignedShortVal();
        this.lengthRange = reader.parseUnsignedShortVal();
    }

    public int getGapStartOffset() {
        return this.gapStartOffset;
    }

    public int getLengthRange() {
        return this.lengthRange;
    }

    @Override
    public void emit(StringBuilder builder) {
        builder.append(String.format(" (%04X, %X)", this.gapStartOffset, this.lengthRange));
    }
}

