/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.symbol;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractDefinedSingleAddressRangeMsSymbol;

public class FramePointerRelativeFullScopeDARMsSymbol
extends AbstractDefinedSingleAddressRangeMsSymbol {
    public static final int PDB_ID = 4420;
    private long offsetToFramePointer;

    public FramePointerRelativeFullScopeDARMsSymbol(AbstractPdb pdb, PdbByteReader reader) throws PdbException {
        super(pdb, reader);
        this.offsetToFramePointer = reader.parseVarSizedOffset(32);
    }

    @Override
    public int getPdbId() {
        return 4420;
    }

    @Override
    protected String getSymbolTypeName() {
        return "DEFRANGE_FRAMEPOINTER_REL_FULL_SCOPE";
    }

    @Override
    public void emit(StringBuilder builder) {
        builder.append(String.format("%s: FrameOffset: %04X FULL_SCOPE", this.getSymbolTypeName(), this.offsetToFramePointer));
    }
}

