/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.type;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.Numeric;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordCategory;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordNumber;
import ghidra.app.util.bin.format.pdb2.pdbreader.StringParseType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractMsType;
import java.math.BigInteger;

public abstract class AbstractArrayMsType
extends AbstractMsType {
    protected RecordNumber elementTypeRecordNumber;
    protected RecordNumber indexTypeRecordNumber;
    protected BigInteger size;
    protected String name;
    protected long stride;

    public AbstractArrayMsType(AbstractPdb pdb, PdbByteReader reader, int recordNumberSize, StringParseType strType, boolean readStride) throws PdbException {
        super(pdb, reader);
        this.elementTypeRecordNumber = RecordNumber.parse(pdb, reader, RecordCategory.TYPE, recordNumberSize);
        this.indexTypeRecordNumber = RecordNumber.parse(pdb, reader, RecordCategory.TYPE, recordNumberSize);
        Numeric numeric = new Numeric(reader);
        if (!numeric.isIntegral()) {
            throw new PdbException("Expecting integral numeric");
        }
        this.size = numeric.getIntegral();
        this.stride = readStride ? reader.parseUnsignedIntVal() : -1L;
        this.name = reader.parseString(pdb, strType);
        reader.skipPadding();
    }

    @Override
    public BigInteger getSize() {
        return this.size;
    }

    public RecordNumber getElementTypeRecordNumber() {
        return this.elementTypeRecordNumber;
    }

    public AbstractMsType getElementType() {
        return this.pdb.getTypeRecord(this.elementTypeRecordNumber);
    }

    public AbstractMsType getIndexType() {
        return this.pdb.getTypeRecord(this.indexTypeRecordNumber);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void emit(StringBuilder builder, AbstractMsType.Bind bind) {
        if (bind.ordinal() < AbstractMsType.Bind.ARRAY.ordinal()) {
            builder.insert(0, "(");
            builder.append(")");
        }
        StringBuilder myBuilder = new StringBuilder();
        myBuilder.append("<");
        myBuilder.append(this.pdb.getTypeRecord(this.indexTypeRecordNumber));
        myBuilder.append(">");
        builder.append("[");
        builder.append(this.size);
        builder.append((CharSequence)myBuilder);
        builder.append("]");
        this.getElementType().emit(builder, AbstractMsType.Bind.ARRAY);
    }
}

