/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pdb;

import ghidra.framework.options.Options;
import ghidra.program.model.listing.Program;
import ghidra.program.util.GhidraProgramUtilities;

public class PdbProgramAttributes {
    private String pdbAge;
    private String pdbGuid;
    private String pdbSignature;
    private String pdbFile;
    private String pdbVersion;
    private boolean pdbLoaded;
    private boolean programAnalyzed;
    private String executablePath;

    public PdbProgramAttributes(Program program) {
        Options propList = program.getOptions("Program Information");
        this.pdbGuid = propList.contains("PDB GUID") ? propList.getString("PDB GUID", null) : null;
        this.pdbAge = propList.contains("PDB Age") ? propList.getString("PDB Age", null) : null;
        this.pdbLoaded = propList.contains("PDB Loaded") ? propList.getBoolean("PDB Loaded", false) : false;
        this.programAnalyzed = GhidraProgramUtilities.isAnalyzed((Program)program);
        this.pdbSignature = propList.contains("PDB Signature") ? propList.getString("PDB Signature", null) : null;
        this.pdbFile = propList.contains("PDB File") ? propList.getString("PDB File", null) : null;
        this.pdbVersion = propList.contains("PDB Version") ? propList.getString("PDB Version", null) : null;
        this.executablePath = program.getExecutablePath();
    }

    public PdbProgramAttributes(String guid, String age, boolean loaded, boolean analyzed, String signature, String file, String execPath) {
        this.pdbGuid = guid;
        this.pdbAge = age;
        this.pdbLoaded = loaded;
        this.programAnalyzed = analyzed;
        this.pdbSignature = signature;
        this.pdbFile = file;
        this.pdbVersion = "RSDS";
        this.executablePath = execPath;
    }

    public String getPdbAge() {
        return this.pdbAge;
    }

    public int getPdbAgeAsInt() {
        try {
            return Integer.parseInt(this.pdbAge, 16);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public String getPdbGuid() {
        return this.pdbGuid;
    }

    public String getPdbSignature() {
        return this.pdbSignature;
    }

    public int getPdbSignatureAsInt() {
        try {
            return Integer.parseUnsignedInt(this.pdbSignature, 16);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public String getPdbFile() {
        return this.pdbFile;
    }

    public String getPdbVersion() {
        return this.pdbVersion;
    }

    public boolean isPdbLoaded() {
        return this.pdbLoaded;
    }

    public String getExecutablePath() {
        return this.executablePath;
    }

    public boolean isProgramAnalyzed() {
        return this.programAnalyzed;
    }
}

