/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pdb.classtype;

import ghidra.app.util.SymbolPath;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.pdb.classtype.VirtualFunctionTable;
import ghidra.app.util.pdb.classtype.VirtualFunctionTableEntry;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.gclass.ClassID;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import java.util.List;
import java.util.TreeMap;

public class ProgramVirtualFunctionTable
extends VirtualFunctionTable {
    private Program program;
    private Address address;
    private int defaultEntrySize;
    private String mangledName;

    public ProgramVirtualFunctionTable(ClassID owner, List<ClassID> parentage, Program program, Address address, int defaultEntrySize, String mangledName) {
        super(owner, parentage);
        if (defaultEntrySize != 4 && defaultEntrySize != 8) {
            throw new IllegalArgumentException("Invalid size (" + defaultEntrySize + "): must be 4 or 8.");
        }
        this.program = program;
        this.address = address;
        this.defaultEntrySize = defaultEntrySize;
        this.mangledName = mangledName;
        this.entriesByTableIndex = new TreeMap();
    }

    public Address getAddress() {
        return this.address;
    }

    public String getMangledName() {
        return this.mangledName;
    }

    @Override
    protected VirtualFunctionTableEntry getNewEntry(SymbolPath originalMethodPath, SymbolPath overrideMethodPath, Pointer functionPointer) {
        return new VirtualFunctionTableEntry(originalMethodPath, overrideMethodPath, functionPointer);
    }

    @Override
    public Address getAddress(int ordinal) throws PdbException {
        Memory memory = this.program.getMemory();
        Address entryAddress = this.address.add((long)(ordinal * this.defaultEntrySize));
        try {
            long offset;
            long l = offset = this.defaultEntrySize == 4 ? Integer.toUnsignedLong(memory.getInt(entryAddress)) : memory.getLong(entryAddress);
            if (offset == 0L) {
                return null;
            }
            Address result = this.address.getNewAddress(offset, false);
            return result;
        }
        catch (MemoryAccessException e) {
            throw new PdbException("MemoryAccessException while trying to parse virtual function table entry at address: " + String.valueOf(entryAddress));
        }
    }

    private VirtualFunctionTableEntry entry(int tableIndex) {
        return (VirtualFunctionTableEntry)this.entriesByTableIndex.get(tableIndex);
    }

    private VirtualFunctionTableEntry existing(int tableIndex) throws PdbException {
        VirtualFunctionTableEntry entry = this.entry(tableIndex);
        if (entry == null) {
            throw new PdbException("No entry in Virtual Function Table for table offset: " + tableIndex);
        }
        return entry;
    }
}

