/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.query.client;

import generic.jar.ResourceFile;
import generic.lsh.vector.IDFLookup;
import generic.lsh.vector.WeightFactory;
import ghidra.features.bsim.query.description.DatabaseInformation;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.NonThreadedXmlPullParserImpl;
import ghidra.xml.XmlPullParser;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Writer;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public class Configuration {
    public DatabaseInformation info;
    public int k;
    public int L;
    public WeightFactory weightfactory;
    public IDFLookup idflookup;

    public void saveXml(Writer fwrite) throws IOException {
        fwrite.write("<dbconfig>\n");
        this.info.saveXml(fwrite);
        StringBuffer buf = new StringBuffer();
        buf.append("<k>").append(this.k).append("</k>\n");
        buf.append("<L>").append(this.L).append("</L>\n");
        fwrite.write(buf.toString());
        this.weightfactory.saveXml(fwrite);
        this.idflookup.saveXml(fwrite);
        fwrite.write("</dbconfig>\n");
    }

    public void restoreXml(XmlPullParser parser) {
        parser.start(new String[]{"dbconfig"});
        this.info = new DatabaseInformation();
        this.info.restoreXml(parser);
        parser.start(new String[]{"k"});
        this.k = SpecXmlUtils.decodeInt((String)parser.end().getText());
        parser.start(new String[]{"L"});
        this.L = SpecXmlUtils.decodeInt((String)parser.end().getText());
        this.weightfactory = new WeightFactory();
        this.weightfactory.restoreXml(parser);
        this.idflookup = new IDFLookup();
        this.idflookup.restoreXml(parser);
        parser.end();
    }

    public void loadTemplate(ResourceFile rootPath, String filename) throws SAXException, IOException {
        ResourceFile file = new ResourceFile(rootPath, filename + ".xml");
        if (!file.exists()) {
            throw new FileNotFoundException("Unable to find configuration template");
        }
        ErrorHandler handler = SpecXmlUtils.getXmlHandler();
        NonThreadedXmlPullParserImpl parser = new NonThreadedXmlPullParserImpl(file.getInputStream(), file.getName(), handler, false);
        parser.start(new String[]{"dbconfig"});
        this.info = new DatabaseInformation();
        this.info.restoreXml((XmlPullParser)parser);
        parser.start(new String[]{"k"});
        this.k = SpecXmlUtils.decodeInt((String)parser.end().getText());
        parser.start(new String[]{"L"});
        this.L = SpecXmlUtils.decodeInt((String)parser.end().getText());
        parser.start(new String[]{"weightsfile"});
        String weightsfile = parser.end().getText();
        parser.end();
        this.weightfactory = new WeightFactory();
        this.idflookup = new IDFLookup();
        if (weightsfile.equals("default")) {
            return;
        }
        file = new ResourceFile(rootPath, weightsfile);
        if (!file.exists()) {
            throw new FileNotFoundException("Unable to find weights file: " + weightsfile);
        }
        parser = new NonThreadedXmlPullParserImpl(file.getInputStream(), file.getName(), handler, false);
        parser.start(new String[]{"weights"});
        this.weightfactory.restoreXml((XmlPullParser)parser);
        this.idflookup.restoreXml((XmlPullParser)parser);
        parser.end();
    }
}

