/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.query.elastic;

import ghidra.features.bsim.gui.filters.BSimFilterType;
import ghidra.features.bsim.query.elastic.ElasticException;
import ghidra.features.bsim.query.elastic.IDElasticResolution;
import ghidra.features.bsim.query.protocol.BSimFilter;
import ghidra.features.bsim.query.protocol.FilterAtom;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class ElasticEffects {
    private int argumentCount = 0;
    private int filterMask = 0;
    private int filterValue = 0;
    private Map<BSimFilterType, List<String>> standaloneFilter = new TreeMap<BSimFilterType, List<String>>();
    private Set<String> docValues = new TreeSet<String>();
    private Map<String, String> params = new TreeMap<String, String>();
    private Map<String, Long> dateParams = new TreeMap<String, Long>();
    private Map<BSimFilterType, List<String>> booleanElements = new TreeMap<BSimFilterType, List<String>>();
    private Set<String> childIds = new TreeSet<String>();
    private Map<String, String> funcParams = new TreeMap<String, String>();

    public String assignArgument() {
        ++this.argumentCount;
        return "arg" + this.argumentCount;
    }

    public void addFunctionFilter(int flag, boolean val) {
        this.filterMask |= flag;
        if (val) {
            this.filterValue |= flag;
        }
    }

    public void addStandalone(BSimFilterType filter, String value) {
        List<String> list = this.standaloneFilter.get(filter);
        if (list == null) {
            list = new ArrayList<String>();
            this.standaloneFilter.put(filter, list);
        }
        list.add(value);
    }

    public void addScriptElement(BSimFilterType filter, String value) {
        List<String> list = this.booleanElements.get(filter);
        if (list == null) {
            list = new ArrayList<String>();
            this.booleanElements.put(filter, list);
        }
        list.add(value);
    }

    public void addDocValue(String val) {
        this.docValues.add(val);
    }

    public void addParam(String key, String val) {
        this.params.put(key, val);
    }

    public void addDateParam(String key, Date date) {
        this.dateParams.put(key, date.getTime());
    }

    public void addFuncParam(String key, String val) {
        this.funcParams.put(key, val);
    }

    public void addChildId(String id) {
        this.childIds.add(id);
    }

    private void buildStandaloneFilters(StringBuilder buffer) {
        boolean needComma = false;
        for (Map.Entry<BSimFilterType, List<String>> entry : this.standaloneFilter.entrySet()) {
            List<String> termList = entry.getValue();
            for (String term : termList) {
                if (needComma) {
                    buffer.append(',');
                } else {
                    needComma = true;
                }
                buffer.append(term);
            }
        }
    }

    private void buildParentScript(StringBuilder buffer) {
        buffer.append("\"inline\": \"");
        for (String string : this.docValues) {
            buffer.append(string);
        }
        buffer.append("return ");
        boolean needsAnd = false;
        for (Map.Entry<BSimFilterType, List<String>> entry : this.booleanElements.entrySet()) {
            BSimFilterType bSimFilterType = entry.getKey();
            String val = bSimFilterType.buildElasticCombinedClause(entry.getValue());
            if (needsAnd) {
                buffer.append(" && ");
            } else {
                needsAnd = true;
            }
            buffer.append(val);
        }
        buffer.append("\"");
        if (!this.params.isEmpty() || !this.dateParams.isEmpty()) {
            buffer.append(", \"params\": {");
            boolean bl = false;
            for (Map.Entry<String, String> entry : this.params.entrySet()) {
                boolean bl2;
                if (bl2) {
                    buffer.append(", ");
                } else {
                    bl2 = true;
                }
                buffer.append('\"').append(entry.getKey()).append("\": \"");
                buffer.append(entry.getValue()).append('\"');
            }
            for (Map.Entry<String, Long> entry : this.dateParams.entrySet()) {
                boolean bl3;
                if (bl3) {
                    buffer.append(", ");
                } else {
                    bl3 = true;
                }
                buffer.append('\"').append(entry.getKey()).append("\": ");
                buffer.append(entry.getValue());
            }
            buffer.append("} ");
        }
    }

    private void buildParentFilterDocument(StringBuilder buffer) {
        buffer.append("\"filter\": { ");
        buffer.append("\"has_parent\": { ");
        buffer.append("\"parent_type\": \"exe\", ");
        buffer.append("\"query\": { ");
        buffer.append("\"bool\": { ");
        boolean needsComma = false;
        if (!this.standaloneFilter.isEmpty()) {
            this.buildStandaloneFilters(buffer);
            needsComma = true;
        }
        if (!this.booleanElements.isEmpty()) {
            if (needsComma) {
                buffer.append(',');
            }
            buffer.append("\"filter\": { ");
            buffer.append("\"script\": { \"script\": { ");
            this.buildParentScript(buffer);
            buffer.append("} } }");
        }
        buffer.append("} } } }");
    }

    private void buildFunctionScriptFilter(StringBuilder buffer) {
        boolean needsAnd = false;
        buffer.append("\"filter\": {");
        buffer.append("\"script\": { \"script\": { ");
        buffer.append("\"inline\": \"");
        if (this.filterMask != 0) {
            buffer.append("int flags = (int)doc['flags'].value; ");
        }
        if (!this.childIds.isEmpty()) {
            buffer.append("def childid = doc['childid']; ");
        }
        buffer.append("return ");
        if (this.filterMask != 0) {
            buffer.append("((flags & params.mask) == params.value)");
            needsAnd = true;
        }
        for (String id : this.childIds) {
            if (needsAnd) {
                buffer.append(" && ");
            }
            buffer.append(id);
            needsAnd = true;
        }
        buffer.append("\", \"params\": { ");
        boolean needsComma = false;
        if (this.filterMask != 0) {
            buffer.append("\"mask\": ").append(this.filterMask);
            buffer.append(", \"value\": ").append(this.filterValue);
            needsComma = true;
        }
        for (Map.Entry<String, String> entry : this.funcParams.entrySet()) {
            if (needsComma) {
                buffer.append(", ");
            } else {
                needsComma = true;
            }
            buffer.append('\"').append(entry.getKey()).append("\": \"");
            buffer.append(entry.getValue()).append('\"');
        }
        buffer.append("} } } }");
    }

    public String buildFunctionFilter() {
        StringBuilder buffer = new StringBuilder();
        if (this.filterMask != 0 || !this.childIds.isEmpty()) {
            buffer.append(", ");
            this.buildFunctionScriptFilter(buffer);
        }
        if (!this.booleanElements.isEmpty() || !this.standaloneFilter.isEmpty()) {
            buffer.append(", ");
            this.buildParentFilterDocument(buffer);
        }
        return buffer.toString();
    }

    public static String createFilter(BSimFilter filter, IDElasticResolution[] idres) throws ElasticException {
        ElasticEffects effects = new ElasticEffects();
        for (int i = 0; i < filter.numAtoms(); ++i) {
            FilterAtom atom = filter.getAtom(i);
            atom.type.gatherElasticEffect(effects, atom, idres[i]);
        }
        return effects.buildFunctionFilter();
    }
}

