/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.query.file;

import ghidra.features.bsim.query.BSimServerInfo;
import ghidra.features.bsim.query.file.H2FileFunctionDatabase;
import ghidra.features.bsim.query.file.VectorStoreEntry;
import ghidra.util.Msg;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.collections4.iterators.EmptyIterator;

public class VectorStore
implements Iterable<VectorStoreEntry> {
    private BSimServerInfo serverInfo;
    private Map<Long, VectorStoreEntry> vectors = null;

    public VectorStore(BSimServerInfo serverInfo) {
        if (serverInfo.getDBType() != BSimServerInfo.DBType.file) {
            throw new IllegalArgumentException("Unsupported DBType");
        }
        this.serverInfo = serverInfo;
    }

    private void init() {
        if (this.vectors == null) {
            try {
                this.loadVectors();
            }
            catch (SQLException e) {
                Msg.error((Object)this, (Object)("Failed to load vectors for " + String.valueOf(this.serverInfo) + ": " + e.getMessage()));
            }
        }
    }

    @Override
    public synchronized Iterator<VectorStoreEntry> iterator() {
        this.init();
        if (this.vectors == null) {
            return EmptyIterator.INSTANCE;
        }
        return this.vectors.values().iterator();
    }

    public synchronized VectorStoreEntry getVectorById(long id) {
        this.init();
        if (this.vectors == null) {
            return null;
        }
        return this.vectors.get(id);
    }

    private void loadVectors() throws SQLException {
        try (H2FileFunctionDatabase fnDb = new H2FileFunctionDatabase(this.serverInfo);){
            if (!fnDb.initialize()) {
                throw new SQLException(fnDb.getLastError().message);
            }
            this.vectors = fnDb.readVectorMap();
        }
    }

    public synchronized void invalidate() {
        this.vectors = null;
    }

    public synchronized void update(VectorStoreEntry entry) {
        if (this.vectors != null) {
            this.vectors.put(entry.id(), entry);
        }
    }

    public synchronized void update(long id, int count) {
        if (this.vectors == null) {
            return;
        }
        VectorStoreEntry entry = this.vectors.get(id);
        if (entry == null) {
            this.invalidate();
        } else {
            this.vectors.put(id, new VectorStoreEntry(id, entry.vec(), count, entry.selfSig()));
        }
    }

    public synchronized void delete(long id) {
        if (this.vectors != null) {
            this.vectors.remove(id);
        }
    }
}

