/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.query.protocol;

import generic.lsh.vector.LSHVectorFactory;
import ghidra.features.bsim.query.LSHException;
import ghidra.features.bsim.query.protocol.BSimQuery;
import ghidra.features.bsim.query.protocol.ResponseOptionalExist;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.XmlPullParser;
import java.io.IOException;
import java.io.Writer;

public class QueryOptionalExist
extends BSimQuery<ResponseOptionalExist> {
    public ResponseOptionalExist optionalresponse = null;
    public String tableName = null;
    public int keyType = -1;
    public int valueType = -1;
    public boolean attemptCreation = false;
    public boolean clearTable = false;

    public QueryOptionalExist() {
        super("queryoptionalexist");
    }

    @Override
    public void buildResponseTemplate() {
        if (this.response == null) {
            this.optionalresponse = new ResponseOptionalExist();
            this.response = this.optionalresponse;
        }
    }

    @Override
    public void saveXml(Writer fwrite) throws IOException {
        fwrite.append('<').append(this.name).append(">\n");
        fwrite.append("<tablename>");
        SpecXmlUtils.xmlEscapeWriter((Writer)fwrite, (String)this.tableName);
        fwrite.append("</tablename>\n");
        fwrite.append("<keytype>");
        fwrite.append(Integer.toString(this.keyType));
        fwrite.append("</keytype>\n");
        fwrite.append("<valuetype>");
        fwrite.append(Integer.toString(this.valueType));
        fwrite.append("</valuetype>\n");
        if (this.attemptCreation) {
            fwrite.append("<create>true</create>\n");
        } else {
            fwrite.append("<create>false</create>\n");
        }
        if (this.clearTable) {
            fwrite.append("<clear>true</clear>\n");
        } else {
            fwrite.append("<clear>false</clear>\n");
        }
        fwrite.append("</").append(this.name).append(">\n");
    }

    @Override
    public void restoreXml(XmlPullParser parser, LSHVectorFactory vectorFactory) throws LSHException {
        parser.start(new String[]{this.name});
        parser.start(new String[]{"tablename"});
        this.tableName = parser.end().getText();
        parser.start(new String[]{"keytype"});
        this.keyType = SpecXmlUtils.decodeInt((String)parser.end().getText());
        parser.start(new String[]{"valuetype"});
        this.valueType = SpecXmlUtils.decodeInt((String)parser.end().getText());
        parser.start(new String[]{"create"});
        this.attemptCreation = SpecXmlUtils.decodeBoolean((String)parser.end().getText());
        parser.start(new String[]{"clear"});
        this.clearTable = SpecXmlUtils.decodeBoolean((String)parser.end().getText());
        parser.end();
    }
}

