/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.analysis;

import ghidra.app.plugin.core.analysis.ConstantPropagationAnalyzer;
import ghidra.app.plugin.core.analysis.ConstantPropagationContextEvaluator;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.DataType;
import ghidra.program.model.lang.Processor;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.util.ContextEvaluator;
import ghidra.program.util.SymbolicPropogator;
import ghidra.program.util.VarnodeContext;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.math.BigInteger;

public class X86Analyzer
extends ConstantPropagationAnalyzer {
    private static final String PROCESSOR_NAME = "x86";

    public X86Analyzer() {
        super(PROCESSOR_NAME);
    }

    public boolean canAnalyze(Program program) {
        return program.getLanguage().getProcessor().equals((Object)Processor.findOrPossiblyCreateProcessor((String)PROCESSOR_NAME));
    }

    public AddressSetView flowConstants(final Program program, Address flowStart, AddressSetView flowSet, SymbolicPropogator symEval, TaskMonitor monitor) throws CancelledException {
        ConstantPropagationContextEvaluator eval = new ConstantPropagationContextEvaluator(this, monitor, this.trustWriteMemOption){

            public boolean evaluateContext(VarnodeContext context, Instruction instr) {
                BigInteger val;
                Register reg;
                String mnemonic = instr.getMnemonicString();
                if (mnemonic.equals("LEA") && (reg = instr.getRegister(0)) != null && (val = context.getValue(reg, false)) != null) {
                    long lval = val.longValue();
                    Address refAddr = instr.getMinAddress().getNewAddress(lval);
                    if ((lval > 4096L || lval < 0L) && program.getMemory().contains(refAddr) && instr.getOperandReferences(1).length == 0) {
                        instr.addOperandReference(1, refAddr, RefType.DATA, SourceType.ANALYSIS);
                    }
                }
                return false;
            }

            public boolean evaluateReference(VarnodeContext context, Instruction instr, int pcodeop, Address address, int size, DataType dataType, RefType refType) {
                if (refType.isFlow() && !instr.getMemory().contains(address) && !address.isExternalAddress()) {
                    return false;
                }
                return super.evaluateReference(context, instr, pcodeop, address, size, dataType, refType);
            }
        };
        eval.setTrustWritableMemory(this.trustWriteMemOption).setMinSpeculativeOffset(this.minSpeculativeRefAddress).setMaxSpeculativeOffset(this.maxSpeculativeRefAddress).setMinStoreLoadOffset(this.minStoreLoadRefAddress).setCreateComplexDataFromPointers(this.createComplexDataFromPointers);
        AddressSet resultSet = symEval.flowConstants(flowStart, flowSet, (ContextEvaluator)eval, true, monitor);
        return resultSet;
    }
}

