/* ###
 * IP: GHIDRA
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package ghidra.feature.vt.api.impl;

import ghidra.framework.model.DomainObjectChangeRecord;

/**
 * Event data for a DomainObjectChangeEvent generated by Version Tracking.
 */
public class VersionTrackingChangeRecord extends DomainObjectChangeRecord {

	private final static long serialVersionUID = 1;

	private Object affected; // may be null

	/**
	 * Construct a new VersionTrackingChangeRecord.
	 * @param eventType event type
	 * @param affected the object that is the subject of this change record; may be null.
	 * @param oldValue the original value; may be null.
	 * @param newValue the new value; may be null.
	 */
	public VersionTrackingChangeRecord(VTEvent eventType, Object affected, Object oldValue,
			Object newValue) {
		super(eventType, oldValue, newValue);
		this.affected = affected;
	}

	/**
	 * Return the object that is the subject of this change record.
	 *
	 * @return Object null if this change record does not have the
	 * affected object
	 */
	public Object getObject() {
		return affected;
	}

	@Override
	public String toString() {
		String s = super.toString();
		if (affected != null) {
			s += ", affected = " + affected;
		}
		return s;
	}
}
