---
stage: Security Risk Management
group: Security Insights
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: Vulnerability archival
---

{{< details >}}

- Tier: Ultimate
- Offering: GitLab.com, GitLab Self-Managed, GitLab Dedicated

{{< /details >}}

{{< history >}}

- Introduced in GitLab 18.0 [with a flag](../../../administration/feature_flags/_index.md) named `vulnerability_archival`. Disabled by default.

{{< /history >}}

{{< alert type="flag" >}}

The availability of this feature is controlled by a feature flag. For more information, see the history.

{{< /alert >}}

To ensure the GitLab database remains performant, vulnerabilities are archived monthly from the
database. Vulnerabilities that were last updated more than one year ago are archived. A
vulnerability is updated every time a change is made, for example, when its status is changed.

Archived vulnerabilities remain available for download for an additional 3 years, after which they are
deleted.

Vulnerability metrics, such as those in the security dashboard and value streams dashboards, include
statistics on archived vulnerabilities.

## Archival process

Every month, the vulnerability archival process runs and does the following:

- Archives vulnerabilities last updated more than 12 months ago.

  Archived vulnerabilities are deleted from the vulnerability report. To retrieve their details,
  download the relevant vulnerability archive.

- Deletes archives created more than 3 years ago.

## Vulnerability archive

A vulnerability archive is a CSV file containing details of all vulnerabilities that were
archived in a specific month or year, or within a specific date range.

### Download a vulnerability archive

Download a vulnerability archive to search or analyze the details it contains.

Prerequisites:

- You must have the Owner role for the project or the `read_vulnerability_archive` permission.

To download a vulnerability archive:

1. On the left sidebar, select **Search or go to** and find your project or group.
1. Select **Secure** > **Security configuration**, then select **Vulnerability Management**.
1. To download details of all vulnerabilities archived:
   - For a specific year, in the row for that year, select **Download all**.
   - For a specific year and month, expand the year, then in the row for that month select **Download** ({{< icon name="download" >}}).
   - For a specific date range, in the **From** and **To** fields enter the dates and then
      select **Download**.

The selected vulnerability archive is downloaded as a CSV file.
